/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.item;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jp.ecuacion.lib.core.annotation.RequireNonempty;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import org.apache.commons.lang3.StringUtils;

public class EclibItem {
    @Nonnull
    protected String itemPropertyPath;
    protected String itemNameKeyClass;
    protected String itemNameKeyField;
    protected boolean showsValue = true;
    private String itemNameKeyClassFromAnnotation;
    private String itemNameKeyClassFromClassName;

    public EclibItem(@RequireNonempty String itemPropertyPath) {
        this.itemPropertyPath = ObjectsUtil.requireNonEmpty(ObjectsUtil.requireNonEmpty(itemPropertyPath));
    }

    public EclibItem itemNameKey(@RequireNonempty String itemNameKey) {
        ObjectsUtil.requireNonEmpty(itemNameKey);
        this.itemNameKeyClass = itemNameKey.contains(".") ? itemNameKey.substring(0, itemNameKey.lastIndexOf(".")) : null;
        this.itemNameKeyField = itemNameKey.contains(".") ? itemNameKey.substring(itemNameKey.lastIndexOf(".") + 1) : itemNameKey;
        return this;
    }

    public String getItemPropertyPath() {
        return this.itemPropertyPath;
    }

    public boolean setsItemNameKeyClassExplicitly() {
        return this.itemNameKeyClass != null;
    }

    @Nonnull
    public String getItemNameKey(@Nullable String defaultItemNameKeyClass) {
        String itemPropertyPathClass;
        String tmpItemNameKeyClass = StringUtils.isNotEmpty((CharSequence)this.itemNameKeyClass) ? this.itemNameKeyClass : (this.itemPropertyPath.contains(".") ? ((itemPropertyPathClass = this.itemPropertyPath.substring(0, this.itemPropertyPath.lastIndexOf("."))).contains(".") ? itemPropertyPathClass.substring(itemPropertyPathClass.lastIndexOf(".") + 1) : itemPropertyPathClass) : (StringUtils.isNotEmpty((CharSequence)this.itemNameKeyClassFromAnnotation) ? this.itemNameKeyClassFromAnnotation : (StringUtils.isNotEmpty((CharSequence)defaultItemNameKeyClass) ? defaultItemNameKeyClass : this.itemNameKeyClassFromClassName)));
        String tmpItemNameKeyField = !StringUtils.isEmpty((CharSequence)this.itemNameKeyField) ? this.itemNameKeyField : (this.itemPropertyPath.contains(".") ? this.itemPropertyPath.substring(this.itemPropertyPath.lastIndexOf(".") + 1) : this.itemPropertyPath);
        return tmpItemNameKeyClass + "." + tmpItemNameKeyField;
    }

    @Nonnull
    public String getItemNameKey() {
        return this.getItemNameKey(null);
    }

    public EclibItem hideValue() {
        this.showsValue = false;
        return this;
    }

    public boolean getShowsValue() {
        return this.showsValue;
    }

    public void setItemNameKeyClassFromAnnotation(String itemNameKeyClas) {
        this.itemNameKeyClassFromAnnotation = itemNameKeyClas;
    }

    public void setItemNameKeyClassFromClassName(String itemNameKeyClassFromClassName) {
        this.itemNameKeyClassFromClassName = itemNameKeyClassFromClassName;
    }
}

