/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.exception.checked.ValidationAppException;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.lib.core.exception.unchecked.UncheckedAppException;
import jp.ecuacion.lib.core.jakartavalidation.bean.ConstraintViolationBean;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.lib.core.util.StringUtil;

public class ExceptionUtil {
    public static final String SYSTEM_ERROR_OCCURED_SIGN = "=============== system error occurred ===============";
    private static final String RT = "\n";

    private ExceptionUtil() {
    }

    @Nonnull
    public static List<String> getMessageList(@RequireNonnull Set<? extends ConstraintViolation<?>> constraintViolation) {
        return ExceptionUtil.getMessageList((Throwable)new ConstraintViolationException(constraintViolation));
    }

    @Nonnull
    public static List<String> getMessageList(@RequireNonnull Set<? extends ConstraintViolation<?>> constraintViolation, Locale locale) {
        return ExceptionUtil.getMessageList((Throwable)new ConstraintViolationException(constraintViolation), locale);
    }

    @Nonnull
    public static List<String> getMessageList(@RequireNonnull Set<? extends ConstraintViolation<?>> constraintViolation, Locale locale, boolean needsItemName) {
        return ExceptionUtil.getMessageList((Throwable)new ConstraintViolationException(constraintViolation), locale, needsItemName);
    }

    @Nonnull
    public static List<String> getMessageList(@RequireNonnull Throwable throwable) {
        return ExceptionUtil.getMessageList(throwable, Locale.getDefault());
    }

    @Nonnull
    public static List<String> getMessageList(@RequireNonnull Throwable throwable, @Nullable Locale locale) {
        return ExceptionUtil.getMessageList(throwable, locale, false);
    }

    @Nonnull
    public static List<String> getMessageList(@RequireNonnull Throwable throwable, @Nullable Locale locale, boolean needsItemName) {
        ObjectsUtil.requireNonNull(throwable);
        locale = locale == null ? Locale.getDefault() : locale;
        ArrayList<Throwable> exList = new ArrayList<Throwable>();
        ArrayList<String> rtnList = new ArrayList<String>();
        if (throwable instanceof ConstraintViolationException) {
            ConstraintViolationException cve = (ConstraintViolationException)throwable;
            for (ConstraintViolation cv : cve.getConstraintViolations()) {
                exList.add(new ValidationAppException(cv));
            }
        } else {
            exList.add(throwable);
        }
        for (Throwable th : exList) {
            Object message;
            SingleAppException ex;
            if (th instanceof MultipleAppException) continue;
            if (th instanceof BizLogicAppException) {
                ex = (BizLogicAppException)th;
                message = needsItemName ? PropertyFileUtil.getMessageWithItemName(locale, ((BizLogicAppException)ex).getMessageId(), ((BizLogicAppException)ex).getMessageArgs()) : PropertyFileUtil.getMessage(locale, ((BizLogicAppException)ex).getMessageId(), ((BizLogicAppException)ex).getMessageArgs());
                rtnList.add((String)message);
                continue;
            }
            if (th instanceof ValidationAppException) {
                ex = (ValidationAppException)th;
                message = null;
                try {
                    ConstraintViolationBean bean = ((ValidationAppException)ex).getConstraintViolationBean();
                    HashMap<String, Object> map = new HashMap<String, Object>(bean.getParamMap());
                    for (ConstraintViolationBean.LocalizedMessageParameter paramBean : bean.getMessageParameterSet()) {
                        if (paramBean.fileKinds() == null || paramBean.fileKinds().length == 0) {
                            map.put(paramBean.parameterKey(), paramBean.propertyFileKey());
                            continue;
                        }
                        String value = "";
                        for (PropertyFileUtil.PropertyFileUtilFileKindEnum fileKind : paramBean.fileKinds()) {
                            value = PropertyFileUtil.get(fileKind.toString(), locale, paramBean.propertyFileKey(), paramBean.args());
                            if (PropertyFileUtil.has(fileKind.toString(), paramBean.propertyFileKey())) break;
                        }
                        map.put(paramBean.parameterKey(), value);
                    }
                    Object object = message = needsItemName || ((ValidationAppException)ex).isMessageWithItemName() ? PropertyFileUtil.getValidationMessageWithItemName(locale, bean.getMessageId(), map) : PropertyFileUtil.getValidationMessage(locale, bean.getMessageId(), map);
                    if (((String)message).contains("{0}")) {
                        List<String> ink = bean.getFieldInfoBeanList().stream().map(b -> b.itemNameKey).toList();
                        message = MessageFormat.format((String)message, ExceptionUtil.getItemNames(locale, ink.toArray(new String[ink.size()])));
                    }
                    if (((ValidationAppException)ex).getMessagePrefix() != null) {
                        message = PropertyFileUtil.getStringFromArg(locale, ((ValidationAppException)ex).getMessagePrefix()) + (String)message;
                    }
                    if (((ValidationAppException)ex).getMessagePostfix() != null) {
                        message = (String)message + PropertyFileUtil.getStringFromArg(locale, ((ValidationAppException)ex).getMessagePostfix());
                    }
                }
                catch (MissingResourceException mre) {
                    message = ((ValidationAppException)ex).getMessage();
                }
                rtnList.add((String)message);
                continue;
            }
            rtnList.add(th.getMessage());
        }
        return rtnList;
    }

    @Nonnull
    private static String getItemNames(Locale locale, @RequireNonnull String[] itemNameKeys) {
        String prependParenthesis = PropertyFileUtil.getMessage(locale, "jp.ecuacion.lib.core.common.itemName.prependParenthesis", new String[0]);
        String appendParenthesis = PropertyFileUtil.getMessage(locale, "jp.ecuacion.lib.core.common.itemName.appendParenthesis", new String[0]);
        String separator = PropertyFileUtil.getMessage(locale, "jp.ecuacion.lib.core.common.itemName.separator", new String[0]);
        List<String> itemNameList = Arrays.asList(ObjectsUtil.requireNonNull(itemNameKeys)).stream().map(key -> PropertyFileUtil.getItemName(locale, key)).map(name -> prependParenthesis + name + appendParenthesis).toList();
        return StringUtil.getSeparatedValuesString(itemNameList, separator);
    }

    @Nonnull
    private static List<Throwable> serializeExceptions(@RequireNonnull Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        ExceptionUtil.recursivelySerializeException(throwable, list);
        return list;
    }

    private static void recursivelySerializeException(@RequireNonnull Throwable throwable, @RequireNonnull List<Throwable> arr) {
        ObjectsUtil.requireNonNull(arr.add(ObjectsUtil.requireNonNull(throwable)));
        if (throwable instanceof MultipleAppException) {
            for (AppException appException : ((MultipleAppException)throwable).getList()) {
                ExceptionUtil.recursivelySerializeException(appException, arr);
            }
        } else if (throwable.getCause() != null) {
            ExceptionUtil.recursivelySerializeException(throwable.getCause(), arr);
        }
    }

    @Nonnull
    public static List<Throwable> getExceptionListWithMessages(@RequireNonnull Throwable throwable) {
        ObjectsUtil.requireNonNull(throwable);
        ArrayList<Throwable> rtnList = new ArrayList<Throwable>();
        for (Throwable th : ExceptionUtil.serializeExceptions(throwable)) {
            if (th instanceof MultipleAppException) continue;
            if (th instanceof UncheckedAppException) {
                rtnList.add(((UncheckedAppException)th).getCause());
                continue;
            }
            if (!(th instanceof SingleAppException) && !(th instanceof EclibRuntimeException) && (th.getMessage() == null || th.getMessage().equals(""))) continue;
            rtnList.add(th);
        }
        return rtnList;
    }

    @Nonnull
    public static List<SingleAppException> getSingleAppExceptionList(@RequireNonnull AppException appException) {
        ObjectsUtil.requireNonNull(appException);
        ArrayList<SingleAppException> rtnList = new ArrayList<SingleAppException>();
        ExceptionUtil.serializeExceptions(appException).forEach(ex -> {
            if (ex instanceof SingleAppException) {
                rtnList.add((SingleAppException)ex);
            }
        });
        if (rtnList.isEmpty()) {
            throw new RuntimeException(appException);
        }
        return rtnList;
    }

    @Nonnull
    public static List<String> getAppExceptionMessageList(@RequireNonnull AppException appException, @Nullable Locale locale) {
        ArrayList<String> rtnList = new ArrayList<String>();
        ExceptionUtil.getSingleAppExceptionList(ObjectsUtil.requireNonNull(appException)).stream().map(ex -> ExceptionUtil.getMessageList(ex, locale, false)).forEach(list -> rtnList.addAll((Collection<String>)list));
        return rtnList;
    }

    @Nonnull
    public static List<String> getAppExceptionMessageList(@RequireNonnull AppException appException, @Nullable Locale locale, boolean needsItemName) {
        ArrayList<String> rtnList = new ArrayList<String>();
        ExceptionUtil.getSingleAppExceptionList(ObjectsUtil.requireNonNull(appException)).stream().map(ex -> ExceptionUtil.getMessageList(ex, locale, needsItemName)).forEach(list -> rtnList.addAll((Collection<String>)list));
        return rtnList;
    }

    @Nonnull
    public static String getErrLogString(@RequireNonnull Throwable throwable, @Nullable String additionalMessage, @Nullable Locale locale) {
        return ExceptionUtil.getErrLogString(throwable, additionalMessage, locale, null);
    }

    @Nonnull
    public static String getErrLogString(@RequireNonnull Throwable throwable, @Nullable String additionalMessage, @Nullable Locale locale, @Nullable Integer packagesShown) {
        ObjectsUtil.requireNonNull(throwable);
        locale = locale == null ? Locale.ENGLISH : locale;
        StringBuilder sb = new StringBuilder();
        sb.append("=============== system error occurred ===============\n");
        if (additionalMessage != null) {
            sb.append(additionalMessage + RT);
            sb.append(RT);
        }
        sb.append(RT);
        ExceptionUtil.getMessageAndStackTraceStringRecursively(sb, throwable, locale, packagesShown);
        return sb.toString();
    }

    public static void getMessageAndStackTraceStringRecursively(StringBuilder sb, Throwable th, Locale locale, Integer packagesShown) {
        ExceptionUtil.getMessageAndStackTraceString(sb, th, locale, packagesShown);
        if (th.getCause() != null) {
            ExceptionUtil.getMessageAndStackTraceStringRecursively(sb, th.getCause(), locale, packagesShown);
        }
    }

    private static void getMessageAndStackTraceString(StringBuilder sb, Throwable th, Locale locale, Integer packagesShown) {
        locale = locale == null ? Locale.ENGLISH : locale;
        String errMsg = th instanceof MultipleAppException ? ((MultipleAppException)th).getMessage() : ExceptionUtil.getMessageList(th, locale, true).toString();
        sb.append(th.getClass().getCanonicalName() + " " + errMsg + RT);
        ExceptionUtil.getStackTraceString(sb, th, packagesShown);
    }

    private static void getStackTraceString(StringBuilder sb, Throwable th, Integer packagesShown) {
        for (StackTraceElement ste : th.getStackTrace()) {
            String[] spl = ste.getClassName().split("\\.");
            Object packageAndClass = ste.getClassName();
            if (packagesShown != null) {
                Object packages = "";
                for (int i = 0; i < packagesShown; ++i) {
                    if (spl.length <= i) continue;
                    packages = (String)packages + spl[i] + (spl.length - 1 == i ? "" : ".");
                }
                packageAndClass = (String)packages + (spl.length > packagesShown ? "." : "");
            }
            sb.append("\tat " + (String)packageAndClass + "." + ste.getMethodName() + "(" + ste.getFileName() + ":" + ste.getLineNumber() + ")\n");
        }
    }
}

