/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.exception.checked;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;

public class BizLogicAppException
extends SingleAppException {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private String messageId;
    @Nonnull
    private PropertyFileUtil.Arg[] messageArgs;
    @Nonnull
    private String[] itemPropertyPaths;

    public BizLogicAppException(@RequireNonnull String messageId, String ... messageArgs) {
        this((String[])null, messageId, messageArgs);
    }

    public BizLogicAppException(@Nullable String[] itemPropertyPaths, @RequireNonnull String messageId, String ... messageArgs) {
        this(itemPropertyPaths, messageId, Arrays.asList(ObjectsUtil.requireNonNull(messageArgs)).stream().map(arg -> PropertyFileUtil.Arg.string(arg)).toList().toArray(new PropertyFileUtil.Arg[messageArgs.length]));
    }

    public BizLogicAppException(@RequireNonnull String messageId, @RequireNonnull PropertyFileUtil.Arg[] messageArgs) {
        this(null, messageId, messageArgs);
    }

    public BizLogicAppException(@Nullable String[] itemPropertyPaths, @RequireNonnull String messageId, @Nullable PropertyFileUtil.Arg[] messageArgs) {
        this.itemPropertyPaths = itemPropertyPaths == null ? new String[]{} : itemPropertyPaths;
        this.messageId = ObjectsUtil.requireNonNull(messageId);
        this.messageArgs = messageArgs == null ? new PropertyFileUtil.Arg[]{} : messageArgs;
    }

    @Override
    public String getMessage() {
        return PropertyFileUtil.getMessage(this.messageId, this.messageArgs);
    }

    @Override
    @Nonnull
    public String[] getItemPropertyPaths() {
        return this.itemPropertyPaths;
    }

    @Nonnull
    public String getMessageId() {
        return this.messageId;
    }

    @Nonnull
    public PropertyFileUtil.Arg[] getMessageArgs() {
        return this.messageArgs == null ? new PropertyFileUtil.Arg[]{} : this.messageArgs;
    }

    public BizLogicAppException cause(Throwable th) {
        super.initCause(th);
        return this;
    }
}

