/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jp.ecuacion.lib.core.util.internal.MailUtilEmailContent;
import jp.ecuacion.lib.core.util.internal.MailUtilEmailServer;
import jp.ecuacion.lib.core.util.internal.MailUtilEmailSettings;

public class MailUtilEmail {
    private HashMap<String, String> detailLogMap = new HashMap();
    private MailUtilEmailServer serverInfo;
    private MailUtilEmailContent contentInfo;
    private MailUtilEmailSettings settingInfo;

    public MailUtilEmail() {
    }

    public MailUtilEmail(MailUtilEmailServer emailServer, MailUtilEmailContent emailContent, MailUtilEmailSettings emailSettings) {
        this.serverInfo = emailServer;
        this.contentInfo = emailContent;
        this.settingInfo = emailSettings;
    }

    public MailUtilEmail(MailUtilEmailServer emailServer, MailUtilEmailContent emailContent, MailUtilEmailSettings emailSettings, HashMap<String, String> detailLogMap) {
        this.serverInfo = emailServer;
        this.contentInfo = emailContent;
        this.settingInfo = emailSettings;
        this.detailLogMap = new HashMap<String, String>(detailLogMap);
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", this.serverInfo.getSmtpServer());
        props.setProperty("mail.smtp.port", this.serverInfo.getPort());
        props.setProperty("mail.smtp.auth", Boolean.valueOf(this.serverInfo.isNeedsAuthentication()).toString());
        String bounce = this.contentInfo.getBounceMailAddress();
        if (bounce != null && !bounce.equals("")) {
            props.setProperty("mail.smtp.from", bounce);
        }
        props.setProperty("mail.debug", Boolean.valueOf(this.settingInfo.getOutputsDebugLog()).toString());
        props.setProperty("mail.smtp.connectiontimeout", "5000");
        props.setProperty("mail.smtp.timeout", "5000");
        if (this.serverInfo.isSslEnabled()) {
            props.setProperty("mail.smtp.starttls.enable", "true");
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            props.setProperty("mail.smtp.socketFactory.port", this.serverInfo.getPort());
            if (this.serverInfo.isChecksCertificate()) {
                props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            } else {
                props.setProperty("mail.smtp.socketFactory.class", "jp.ecuacion.framework.common.common.util.AuthUtilDummySSLSocketFactory");
            }
        }
        return props;
    }

    public String getDebugLogMessage() {
        if (this.detailLogMap == null || this.detailLogMap.size() == 0) {
            return ". (parameter none)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(": ");
        boolean is1st = true;
        for (Map.Entry<String, String> entry : this.detailLogMap.entrySet()) {
            if (is1st) {
                is1st = false;
            } else {
                sb.append(", ");
            }
            sb.append(entry.getKey() + " = " + entry.getValue());
        }
        return sb.toString();
    }

    public MailUtilEmailServer getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(MailUtilEmailServer serverInfo) {
        this.serverInfo = serverInfo;
    }

    public MailUtilEmailContent getContentInfo() {
        return this.contentInfo;
    }

    public void setContentInfo(MailUtilEmailContent contentInfo) {
        this.contentInfo = contentInfo;
    }

    public MailUtilEmailSettings getSettingInfo() {
        return this.settingInfo;
    }

    public void setSettingInfo(MailUtilEmailSettings settingInfo) {
        this.settingInfo = settingInfo;
    }

    public HashMap<String, String> getDetailLogMap() {
        return new HashMap<String, String>(this.detailLogMap);
    }

    public void setDetailLogMap(HashMap<String, String> detailLogMap) {
        this.detailLogMap = new HashMap<String, String>(detailLogMap);
    }
}

