/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.jakartavalidation.validator.internal;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.lib.core.jakartavalidation.validator.enums.TypeConversionFromString;
import jp.ecuacion.lib.core.jakartavalidation.validator.internal.ClassValidator;
import jp.ecuacion.lib.core.util.ReflectionUtil;

public abstract class ComparisonValidator
extends ClassValidator {
    private String basisPropertyPath;
    private boolean isValidWhenLessThanBasis;
    private boolean allowsEqual;
    private TypeConversionFromString typeConversionFromString;
    private Field fieldOfBasisPropertyPath;
    private Object valueOfBasisPropertyPath;

    public void initialize(String[] propertyPath, String basisPropertyPath, boolean isValidWhenLessThanBasis, boolean allowsEqual, TypeConversionFromString typeConversionFromString) {
        super.initialize(propertyPath);
        this.basisPropertyPath = basisPropertyPath;
        this.isValidWhenLessThanBasis = isValidWhenLessThanBasis;
        this.allowsEqual = allowsEqual;
        this.typeConversionFromString = typeConversionFromString;
    }

    @Override
    protected void procedureBeforeLoopForEachPropertyPath() {
        this.fieldOfBasisPropertyPath = ReflectionUtil.getField(this.instance.getClass(), this.basisPropertyPath);
        this.valueOfBasisPropertyPath = ComparisonValidator.getValue(this.instance, this.basisPropertyPath);
    }

    @Override
    protected boolean isValidForSinglePropertyPath(String propertyPath, Object valueOfPropertyPath) {
        Boolean validWhenLessThanBasis;
        boolean isValueOfBasisPropertyPathEmpty;
        Field fieldOfPropertyPath = ReflectionUtil.getField(this.instance.getClass(), propertyPath);
        if (!fieldOfPropertyPath.getType().isAssignableFrom(this.fieldOfBasisPropertyPath.getType())) {
            throw new EclibRuntimeException("Types of two propertyPath differ. propertyPath: " + String.valueOf(fieldOfPropertyPath.getType()) + ", basisPropertyPath: " + String.valueOf(this.fieldOfBasisPropertyPath.getType()));
        }
        boolean isValueOfPropertyPathEmpty = valueOfPropertyPath == null || valueOfPropertyPath instanceof String && ((String)valueOfPropertyPath).equals("");
        boolean bl = isValueOfBasisPropertyPathEmpty = this.valueOfBasisPropertyPath == null || this.valueOfBasisPropertyPath instanceof String && ((String)this.valueOfBasisPropertyPath).equals("");
        if (isValueOfPropertyPathEmpty || isValueOfBasisPropertyPathEmpty) {
            return true;
        }
        if (valueOfPropertyPath.equals(this.valueOfBasisPropertyPath)) {
            return this.allowsEqual;
        }
        if (this.typeConversionFromString != TypeConversionFromString.NONE) {
            if (!(valueOfPropertyPath instanceof String)) {
                String msg = "The type of propertyPath needs to be String when typeConversionFromString is not 'NONE'.";
                throw new EclibRuntimeException(msg);
            }
            String valOfPp = (String)valueOfPropertyPath;
            String valOfBpp = (String)this.valueOfBasisPropertyPath;
            if (this.typeConversionFromString == TypeConversionFromString.NUMBER) {
                valueOfPropertyPath = Double.valueOf(valOfPp.replaceAll(",", ""));
                this.valueOfBasisPropertyPath = Double.valueOf(valOfBpp.replaceAll(",", ""));
            } else if (this.typeConversionFromString == TypeConversionFromString.DATE) {
                DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                valueOfPropertyPath = LocalDate.parse(valOfPp, fmt);
                this.valueOfBasisPropertyPath = LocalDate.parse(valOfBpp, fmt);
            }
        }
        Object object = valueOfPropertyPath;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Integer.class, Short.class, Byte.class, Double.class, Float.class, BigInteger.class, BigDecimal.class, LocalDate.class, LocalDateTime.class, OffsetDateTime.class, ZonedDateTime.class, String.class}, (Object)object2, n)) {
            case 0: {
                Long x = (Long)object2;
                Boolean bl2 = x < (Long)this.valueOfBasisPropertyPath;
                break;
            }
            case 1: {
                Integer x = (Integer)object2;
                Boolean bl2 = x < (Integer)this.valueOfBasisPropertyPath;
                break;
            }
            case 2: {
                Short x = (Short)object2;
                Boolean bl2 = x < (Short)this.valueOfBasisPropertyPath;
                break;
            }
            case 3: {
                Byte x = (Byte)object2;
                Boolean bl2 = x < (Byte)this.valueOfBasisPropertyPath;
                break;
            }
            case 4: {
                Double x = (Double)object2;
                Boolean bl2 = x < (Double)this.valueOfBasisPropertyPath;
                break;
            }
            case 5: {
                Float x = (Float)object2;
                Boolean bl2 = x.floatValue() < ((Float)this.valueOfBasisPropertyPath).floatValue();
                break;
            }
            case 6: {
                BigInteger x = (BigInteger)object2;
                Boolean bl2 = x.compareTo((BigInteger)this.valueOfBasisPropertyPath) < 0;
                break;
            }
            case 7: {
                BigDecimal x = (BigDecimal)object2;
                Boolean bl2 = x.compareTo((BigDecimal)this.valueOfBasisPropertyPath) < 0;
                break;
            }
            case 8: {
                LocalDate x = (LocalDate)object2;
                Boolean bl2 = x.isBefore((LocalDate)this.valueOfBasisPropertyPath);
                break;
            }
            case 9: {
                LocalDateTime x = (LocalDateTime)object2;
                Boolean bl2 = x.isBefore((LocalDateTime)this.valueOfBasisPropertyPath);
                break;
            }
            case 10: {
                OffsetDateTime x = (OffsetDateTime)object2;
                Boolean bl2 = x.isBefore((OffsetDateTime)this.valueOfBasisPropertyPath);
                break;
            }
            case 11: {
                ZonedDateTime x = (ZonedDateTime)object2;
                Boolean bl2 = x.isBefore((ZonedDateTime)this.valueOfBasisPropertyPath);
                break;
            }
            case 12: {
                String x = (String)object2;
                Boolean bl2 = this.isStringValidWhenLessThanBasis(x, (String)this.valueOfBasisPropertyPath);
                break;
            }
            default: {
                Boolean bl2 = validWhenLessThanBasis = null;
            }
        }
        if (validWhenLessThanBasis == null) {
            throw new EclibRuntimeException("The type of propertyPath is unexpected. type: " + fieldOfPropertyPath.getType().getCanonicalName());
        }
        return this.isValidWhenLessThanBasis ? validWhenLessThanBasis : validWhenLessThanBasis == false;
    }

    protected boolean isStringValidWhenLessThanBasis(String x1, String x2) {
        try {
            byte[] bytesPropertyPath = x1.getBytes("UTF-8");
            byte[] bytesBasisPropertyPath = x2.getBytes("UTF-8");
            for (int i = 0; i < bytesPropertyPath.length; ++i) {
                byte bytePropertyPath = bytesPropertyPath[i];
                if (bytesBasisPropertyPath.length <= i) {
                    return false;
                }
                byte byteBasisPropertyPath = bytesBasisPropertyPath[i];
                if (bytePropertyPath == byteBasisPropertyPath) continue;
                return bytePropertyPath < byteBasisPropertyPath;
            }
            return true;
        }
        catch (UnsupportedEncodingException e) {
            throw new EclibRuntimeException(e);
        }
    }
}

