/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.item;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import jp.ecuacion.lib.core.annotation.RequireNonempty;
import jp.ecuacion.lib.core.item.EclibItem;
import jp.ecuacion.lib.core.jakartavalidation.annotation.ItemNameKeyClass;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.ReflectionUtil;
import org.apache.commons.lang3.StringUtils;

public interface EclibItemContainer {
    @Nullable
    public EclibItem[] getItems();

    @Nonnull
    default public EclibItem getNewItem(@RequireNonempty String itemPropertyPath) {
        return new EclibItem(ObjectsUtil.requireNonEmpty(itemPropertyPath));
    }

    @Nonnull
    default public EclibItem getItem(@RequireNonempty String itemPropertyPath) {
        Map<String, EclibItem> map = Arrays.asList(this.getItems() == null ? new EclibItem[]{} : this.getItems()).stream().collect(Collectors.toMap(e -> e.getItemPropertyPath(), e -> e));
        EclibItem item = map.get(ObjectsUtil.requireNonEmpty(itemPropertyPath));
        item = item == null ? this.getNewItem(itemPropertyPath) : item;
        Optional<ItemNameKeyClass> optAn = ReflectionUtil.searchAnnotationPlacedAtClass(this.getClass(), ItemNameKeyClass.class);
        String itemNameKeyClass = optAn.isPresent() ? optAn.get().value() : this.getClass().getSimpleName();
        item.setFinalDefaultItemNameKeyClass(StringUtils.uncapitalize((String)itemNameKeyClass));
        return item;
    }

    @Nonnull
    default public EclibItem[] mergeItems(@Nullable EclibItem[] items1, @Nullable EclibItem[] items2) {
        items1 = items1 == null ? new EclibItem[]{} : items1;
        items2 = items2 == null ? new EclibItem[]{} : items2;
        ArrayList<EclibItem> list = new ArrayList<EclibItem>(Arrays.asList(items1));
        List<String> propertyPath1List = Arrays.asList(items1).stream().map(e -> e.getItemPropertyPath()).toList();
        for (String propertyPath2 : Arrays.asList(items2).stream().map(e -> e.getItemPropertyPath()).toList()) {
            if (!propertyPath1List.contains(propertyPath2)) continue;
            throw new RuntimeException("'itemPropertyPath' of EclibItem[] duplicated in Items. key: " + propertyPath2);
        }
        list.addAll(Arrays.asList(items2));
        return list.toArray(new EclibItem[list.size()]);
    }
}

