/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.exception.checked;

import jakarta.annotation.Nonnull;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.util.ObjectsUtil;

public class AppWarningException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected String messageId;
    protected String[] messageArgs;
    protected String[] itemPropertyPaths;

    public AppWarningException(@RequireNonnull String messageId, String ... messageArgs) {
        this(new String[0], messageId, messageArgs);
    }

    public AppWarningException(@RequireNonnull String[] itemPropertyPaths, @RequireNonnull String messageId, String ... messageArgs) {
        this.messageId = ObjectsUtil.requireNonNull(messageId);
        this.messageArgs = ObjectsUtil.requireNonNull(messageArgs);
        this.itemPropertyPaths = ObjectsUtil.requireNonNull(itemPropertyPaths);
    }

    @Nonnull
    public String getMessageId() {
        return this.messageId;
    }

    @Nonnull
    public String[] getMessageArgs() {
        return (String[])this.messageArgs.clone();
    }

    @Nonnull
    public String[] getItemPropertyPaths() {
        return this.itemPropertyPaths;
    }

    @Nonnull
    public AppWarningException itemPropertyPaths(@RequireNonnull String[] itemPropertyPaths) {
        this.itemPropertyPaths = ObjectsUtil.requireNonNull(itemPropertyPaths);
        return this;
    }
}

