/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util.internal;

import jakarta.annotation.Nonnull;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;

public class ReflectionUtil {
    public static <A extends Annotation> Optional<A> searchAnnotationPlacedAtClass(Class<?> classOfTargetInstance, Class<A> annotation) {
        while (classOfTargetInstance != Object.class) {
            A an = classOfTargetInstance.getAnnotation(annotation);
            if (an != null) {
                return Optional.of(an);
            }
            classOfTargetInstance = classOfTargetInstance.getSuperclass();
        }
        return Optional.empty();
    }

    protected static Object getFieldValue(String propertyPath, Object instance) {
        try {
            String chileItemPropertyPath = propertyPath.substring(propertyPath.indexOf(".") + 1);
            if (propertyPath.contains(".")) {
                String rootFieldName = propertyPath.substring(0, propertyPath.indexOf("."));
                return ReflectionUtil.getFieldValue(chileItemPropertyPath, ReflectionUtil.getFieldValue(rootFieldName, instance));
            }
            if (propertyPath.contains("[")) {
                String propertyPathWithoutIndex = propertyPath.substring(0, propertyPath.indexOf("["));
                String tmpSerial = propertyPath.substring(propertyPath.indexOf("[") + 1);
                String index = tmpSerial.substring(0, tmpSerial.indexOf("]"));
                Field rootField = ReflectionUtil.getField(propertyPathWithoutIndex, instance.getClass());
                rootField.setAccessible(true);
                Object objs = rootField.get(instance);
                if (objs instanceof Object[]) {
                    return ((Object[])objs)[Integer.parseInt(index)];
                }
                if (objs instanceof List) {
                    return ((List)objs).get(Integer.parseInt(index));
                }
                throw new EclibRuntimeException("Multiple value types other than array and List are not supported. The type of value: " + objs.getClass().getCanonicalName());
            }
            Field rootField = ReflectionUtil.getField(propertyPath, instance.getClass());
            rootField.setAccessible(true);
            return rootField.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            ReflectionUtil.throwRuntimeException(ex, propertyPath, "Field value");
            return null;
        }
    }

    @Nonnull
    static Field getField(String fieldName, Class<?> classOfTargetInstance) {
        Exception ex = null;
        if (fieldName.contains(".")) {
            throw new EclibRuntimeException("fieldName cannot contain '.'.");
        }
        if (fieldName.contains("[")) {
            throw new EclibRuntimeException("fieldName with index (like value[0]) not acceptable. fieldName: " + fieldName);
        }
        while (!classOfTargetInstance.equals(Object.class)) {
            try {
                Field validationTargetField = classOfTargetInstance.getDeclaredField(fieldName);
                return validationTargetField;
            }
            catch (Exception exception) {
                if (ex == null) {
                    ex = exception;
                }
                classOfTargetInstance = classOfTargetInstance.getSuperclass();
            }
        }
        ReflectionUtil.throwRuntimeException(ex, fieldName, "Field");
        return null;
    }

    private static void throwRuntimeException(Exception ex, String fieldName, String whatIsTriedToObtain) {
        throw new EclibRuntimeException(whatIsTriedToObtain + " cannot be obtained from the field name '" + fieldName + "'", ex);
    }
}

