/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import jp.ecuacion.lib.core.annotation.RequireElementNonempty;
import jp.ecuacion.lib.core.annotation.RequireElementNonnull;
import jp.ecuacion.lib.core.annotation.RequireNonempty;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.annotation.RequireSizeNonzero;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ObjectsUtil {
    private ObjectsUtil() {
    }

    @Nonnull
    public static <T> T requireNonNull(@RequireNonnull T object) {
        if (object == null) {
            throw new RequireNonNullException();
        }
        return object;
    }

    @Nonnull
    public static void requireNonNull(@RequireNonnull Object object1, @RequireNonnull Object object2, Object ... objects) {
        Object[] allObjects;
        for (Object object : allObjects = ArrayUtils.addAll((Object[])objects, (Object[])new Object[]{object1, object2})) {
            ObjectsUtil.requireNonNull(object);
        }
    }

    @Nonnull
    public static String requireNonEmpty(@RequireNonempty String string) {
        if (string == null || string.equals("")) {
            throw new RequireNonEmptyException();
        }
        return string;
    }

    @Nonnull
    public static void requireNonEmpty(@RequireNonempty String string1, @RequireNonempty String string2, String ... strings) {
        String[] allStrings;
        for (String string : allStrings = (String[])ArrayUtils.addAll((Object[])strings, (Object[])new String[]{string1, string2})) {
            ObjectsUtil.requireNonEmpty(string);
        }
    }

    @Nonnull
    public static <T> T[] requireSizeNonZero(@RequireSizeNonzero T[] objects) {
        ObjectsUtil.requireSizeNonZero(Arrays.asList(objects));
        return objects;
    }

    @Nonnull
    public static <T> Collection<T> requireSizeNonZero(@RequireSizeNonzero Collection<T> collection) {
        if (collection != null && collection.size() == 0) {
            throw new RequireSizeNonZeroException();
        }
        return collection;
    }

    @Nonnull
    public static <T> T[] requireElementNonNull(@RequireElementNonnull T[] objects) {
        ObjectsUtil.requireElementNonNull(Arrays.asList(objects));
        return objects;
    }

    @Nonnull
    public static <T> Collection<T> requireElementNonNull(@RequireElementNonnull Collection<T> collection) {
        if (collection != null) {
            for (T object : collection) {
                if (object != null) continue;
                throw new RequireElementNonNullException();
            }
        }
        return collection;
    }

    @Nonnull
    public static String[] requireElementNonEmpty(@RequireElementNonempty String[] strings) {
        if (strings != null) {
            for (String string : strings) {
                if (!StringUtils.isEmpty((CharSequence)string)) continue;
                throw new RequireElementNonEmptyException();
            }
        }
        return strings;
    }

    @Nonnull
    public static Collection<String> requireElementNonEmpty(@RequireElementNonempty Collection<String> collection) {
        ObjectsUtil.requireElementNonEmpty(collection.toArray(new String[collection.size()]));
        return collection;
    }

    @Nonnull
    public static <T> T[] requireElementsNonDuplicated(@RequireElementNonnull T[] objects) {
        ObjectsUtil.requireElementsNonDuplicated(Arrays.asList(objects));
        return objects;
    }

    @Nonnull
    public static <T> Collection<T> requireElementsNonDuplicated(@RequireElementNonnull Collection<T> collection) {
        HashSet set = new HashSet();
        if (collection != null) {
            for (T object : collection) {
                if (!set.contains(object)) continue;
                throw new RequireElementsNonDuplicatedException();
            }
        }
        return collection;
    }

    public static class RequireNonNullException
    extends ObjectsUtilException {
        private static final long serialVersionUID = 1L;

        public RequireNonNullException() {
            super("Non-null required.");
        }
    }

    public static class RequireNonEmptyException
    extends ObjectsUtilException {
        private static final long serialVersionUID = 1L;

        public RequireNonEmptyException() {
            super("Non-empty required.");
        }
    }

    public static class RequireSizeNonZeroException
    extends ObjectsUtilException {
        private static final long serialVersionUID = 1L;

        public RequireSizeNonZeroException() {
            super("Size non-zero required.");
        }
    }

    public static class RequireElementNonNullException
    extends ObjectsUtilException {
        private static final long serialVersionUID = 1L;

        public RequireElementNonNullException() {
            super("Element non-null required.");
        }
    }

    public static class RequireElementNonEmptyException
    extends ObjectsUtilException {
        private static final long serialVersionUID = 1L;

        public RequireElementNonEmptyException() {
            super("Element non-empty required.");
        }
    }

    public static class RequireElementsNonDuplicatedException
    extends ObjectsUtilException {
        private static final long serialVersionUID = 1L;

        public RequireElementsNonDuplicatedException() {
            super("Elements non-duplicated required.");
        }
    }

    public static abstract class ObjectsUtilException
    extends EclibRuntimeException {
        private static final long serialVersionUID = 1L;

        public ObjectsUtilException(String message) {
            super(message);
        }
    }
}

