/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util.internal;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.unchecked.RuntimeSystemException;
import jp.ecuacion.lib.core.util.LogUtil;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.lib.core.util.internal.PropertyFileUtilFileKindEnum;
import org.apache.commons.lang3.tuple.Pair;

public class PropertyFileUtilValueGetter {
    private PropertyFileUtilFileKindEnum kind;
    private String filePrefix;
    private static final String[] LIB_MODULES = new String[]{"core", "jpa"};
    private static final String[] SPLIB_MODULES = new String[]{"web"};
    private static final String[] UTIL_MODULES = new String[]{"jpa", "poi"};
    private static final String[] APP_MODULES = new String[]{"", "base", "core", "core_web", "core_batch"};
    private static final String[] APP_ENVS = new String[]{"", "profile"};
    private static final List<String> dynamicPostfixList = new ArrayList<String>();
    public static final ThreadLocal<String> bundleNameForModule = new ThreadLocal();
    public static final ThreadLocal<Locale> specifiedLocale = new ThreadLocal();

    public static void addToDynamicPostfixList(String postfix) {
        if (!dynamicPostfixList.contains(postfix)) {
            dynamicPostfixList.add(postfix);
        }
    }

    static List<String> getDynamicPostfixList() {
        return new ArrayList<String>(dynamicPostfixList);
    }

    public PropertyFileUtilValueGetter(@RequireNonnull PropertyFileUtilFileKindEnum fileKindEnum) {
        this.kind = ObjectsUtil.paramRequireNonNull(fileKindEnum);
        this.filePrefix = fileKindEnum.getFilePrefix();
    }

    PropertyFileUtilValueGetter(@RequireNonnull String filePrefix) {
        Objects.requireNonNull(filePrefix);
        this.kind = PropertyFileUtilFileKindEnum.MSG;
        this.filePrefix = filePrefix;
    }

    List<String> getPostfixes() {
        ArrayList<String> rtnList = new ArrayList<String>();
        rtnList.addAll(Arrays.asList(LIB_MODULES).stream().map(str -> "lib_" + str).collect(Collectors.toList()));
        rtnList.addAll(Arrays.asList(SPLIB_MODULES).stream().map(str -> "splib_" + str).collect(Collectors.toList()));
        rtnList.addAll(Arrays.asList(UTIL_MODULES).stream().map(str -> "util_" + str).toList());
        rtnList.addAll(dynamicPostfixList);
        for (String systemModuleName : APP_MODULES) {
            for (String envName : APP_ENVS) {
                boolean needsUs = !systemModuleName.equals("") && !envName.equals("");
                rtnList.add(systemModuleName + (needsUs ? "_" : "") + envName);
            }
        }
        return rtnList;
    }

    @Nonnull
    private String readPropFile(@Nullable Locale locale, @RequireNonnull String key) {
        List<String> postfixes = this.getPostfixes();
        HashMap<Object, ResourceBundle> rbMapForModule = new HashMap<Object, ResourceBundle>();
        for (int i = 0; i < postfixes.size(); ++i) {
            String postfix = postfixes.get(i);
            Object filename = this.filePrefix + (postfix.equals("") ? "" : "_") + postfix;
            ResourceBundle bundle = this.getOneResourceBundle((String)filename, locale, key);
            rbMapForModule.put(filename, bundle);
            if (this.kind != PropertyFileUtilFileKindEnum.MSG) continue;
            filename = "ValidationMessages";
            rbMapForModule.put(filename, this.getOneResourceBundle((String)filename, locale, key));
        }
        HashSet<String> duplicateCheckMap = new HashSet<String>();
        for (Map.Entry entry : rbMapForModule.entrySet()) {
            if (entry.getValue() != null) {
                for (String keyInBundle : ((ResourceBundle)entry.getValue()).keySet()) {
                    if (duplicateCheckMap.contains(keyInBundle)) {
                        throw new RuntimeSystemException("Key '" + keyInBundle + "' in properties file duplicated. ");
                    }
                    duplicateCheckMap.add(keyInBundle);
                }
            }
            rbMapForModule.put((String)entry.getKey(), (ResourceBundle)entry.getValue());
        }
        for (Map.Entry entry : rbMapForModule.entrySet()) {
            if (entry.getValue() == null || !((ResourceBundle)entry.getValue()).containsKey(key)) continue;
            String value = ((ResourceBundle)entry.getValue()).getString(key);
            List<Pair<PropertyFileUtilFileKindEnum, String>> list = this.analyze(value);
            StringBuilder sb = new StringBuilder();
            for (Pair<PropertyFileUtilFileKindEnum, String> tuple : list) {
                if (tuple.getLeft() == null) {
                    sb.append((String)tuple.getRight());
                    continue;
                }
                sb.append(PropertyFileUtil.get(((PropertyFileUtilFileKindEnum)((Object)tuple.getLeft())).getFilePrefix(), (String)tuple.getRight()));
            }
            return sb.toString();
        }
        return null;
    }

    private List<Pair<PropertyFileUtilFileKindEnum, String>> analyze(String string) {
        String startBracket = "${";
        String endBracket = "}";
        ArrayList<Pair<PropertyFileUtilFileKindEnum, String>> list = new ArrayList<Pair<PropertyFileUtilFileKindEnum, String>>();
        String stringLeft = string;
        while (true) {
            int indexOfStartBracket = stringLeft.indexOf("${");
            int indexOfEndBracket = stringLeft.indexOf("}");
            if (indexOfStartBracket == -1) break;
            if (indexOfStartBracket > indexOfEndBracket) {
                throw new RuntimeSystemException("startBracketFollowsEndBracket. the brackets in the string is somehow wrong. string: " + stringLeft);
            }
            list.add((Pair<PropertyFileUtilFileKindEnum, String>)Pair.of(null, (Object)stringLeft.substring(0, indexOfStartBracket)));
            String stringInBrackets = stringLeft.substring(indexOfStartBracket + "${".length(), indexOfEndBracket);
            PropertyFileUtilFileKindEnum fileKind = this.getFileKindFromStringInBrackets(stringInBrackets);
            if (fileKind == null) {
                list.add((Pair<PropertyFileUtilFileKindEnum, String>)Pair.of(null, (Object)stringLeft.substring(indexOfStartBracket, indexOfEndBracket + "}".length())));
            } else {
                list.add((Pair<PropertyFileUtilFileKindEnum, String>)Pair.of((Object)((Object)fileKind), (Object)stringInBrackets.split(":")[1]));
            }
            stringLeft = stringLeft.substring(indexOfEndBracket + "}".length());
        }
        list.add(Pair.of(null, (Object)stringLeft));
        return list;
    }

    private PropertyFileUtilFileKindEnum getFileKindFromStringInBrackets(String stringInBrackets) {
        if (!stringInBrackets.contains(":")) {
            return null;
        }
        return PropertyFileUtilFileKindEnum.getEnumFromFilePrefix(stringInBrackets.split(":")[0]);
    }

    @Nonnull
    private ResourceBundle getOneResourceBundle(@RequireNonnull String filename, @Nullable Locale locale, @RequireNonnull String key) {
        ObjectsUtil.paramRequireNonNull(filename);
        ObjectsUtil.paramRequireNonNull(key);
        if (locale == null) {
            locale = Locale.ROOT;
        }
        try {
            bundleNameForModule.set(filename);
            specifiedLocale.set(locale);
            String bundle = "jp.ecuacion.lib.core." + new StringUtil().getUpperCamelFromSnakeOrNullIfInputIsNull(filename.replaceAll("-", "_"));
            return ResourceBundle.getBundle(bundle, locale);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                return ResourceBundle.getBundle(filename, locale, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES));
            }
            catch (UnsupportedOperationException | MissingResourceException runtimeException) {
                return null;
            }
        }
    }

    public boolean hasProp(String key) {
        Objects.requireNonNull(key);
        String val = this.readPropFile(null, key);
        return val != null;
    }

    public String getProp(String key) {
        return this.getProp(null, key);
    }

    public String getProp(@Nullable Locale locale, @RequireNonnull String key) {
        ObjectsUtil.paramRequireNonNull(key);
        if (key.equals("")) {
            throw new RuntimeSystemException("Message ID is blank.");
        }
        String str = this.readPropFile(locale, key);
        String defaultStr = this.readPropFile(locale, key + ".default");
        if (str == null && defaultStr == null) {
            try {
                throw new RuntimeException("No key in .properties. key: " + key);
            }
            catch (Exception e) {
                new LogUtil(this).logError((Throwable)e, (String)null);
                throw e;
            }
        }
        return str != null ? str : defaultStr;
    }

    public boolean isOverrided(@RequireNonnull String key) {
        return System.getProperties().keySet().contains(key);
    }
}

