/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.util.internal.PropertyFileUtilFileKindEnum;
import jp.ecuacion.lib.core.util.internal.PropertyFileUtilValueGetter;

public class PropertyFileUtil {
    private static Map<PropertyFileUtilFileKindEnum, PropertyFileUtilValueGetter> getterMap = new HashMap<PropertyFileUtilFileKindEnum, PropertyFileUtilValueGetter>();

    private PropertyFileUtil() {
    }

    @Nonnull
    public static String getApp(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.APP).getProp(key);
    }

    public static boolean hasApp(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.APP).hasProp(key);
    }

    @Nonnull
    public static String getMsg(@RequireNonnull String key, String ... args) {
        return PropertyFileUtil.getMsg(null, key, args);
    }

    @Nonnull
    public static String getMsg(@Nullable Locale locale, @RequireNonnull String key, String ... args) {
        String msgStr = getterMap.get((Object)PropertyFileUtilFileKindEnum.MSG).getProp(locale, key);
        return args.length == 0 ? msgStr : MessageFormat.format(msgStr, args);
    }

    public static boolean hasMsg(@RequireNonnull String msgId) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.MSG).hasProp(msgId);
    }

    @Nonnull
    public static String getItemName(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ITEM_NAME).getProp(null, key);
    }

    @Nonnull
    public static String getItemName(@Nullable Locale locale, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ITEM_NAME).getProp(locale, key);
    }

    public static boolean hasItemName(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ITEM_NAME).hasProp(key);
    }

    @Nonnull
    public static String getEnumName(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ENUM_NAME).getProp(null, key);
    }

    @Nonnull
    public static String getEnumName(@Nullable Locale locale, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ENUM_NAME).getProp(locale, key);
    }

    public static boolean hasEnumName(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ENUM_NAME).hasProp(key);
    }

    @Nonnull
    public static String get(@RequireNonnull String propertyUtilFileKind, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.getEnumFromFilePrefix(propertyUtilFileKind)).getProp(null, key);
    }

    @Nonnull
    public static String get(@RequireNonnull String propertyUtilFileKind, @Nullable Locale locale, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.getEnumFromFilePrefix(propertyUtilFileKind)).getProp(locale, key);
    }

    public static boolean has(@RequireNonnull String propertyUtilFileKind, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.getEnumFromFilePrefix(propertyUtilFileKind)).hasProp(key);
    }

    public static void addResourceBundlePostfix(String postfix) {
        PropertyFileUtilValueGetter.addToDynamicPostfixList(postfix);
    }

    static {
        getterMap.put(PropertyFileUtilFileKindEnum.APP, new PropertyFileUtilValueGetter(PropertyFileUtilFileKindEnum.APP));
        getterMap.put(PropertyFileUtilFileKindEnum.MSG, new PropertyFileUtilValueGetter(PropertyFileUtilFileKindEnum.MSG));
        getterMap.put(PropertyFileUtilFileKindEnum.ITEM_NAME, new PropertyFileUtilValueGetter(PropertyFileUtilFileKindEnum.ITEM_NAME));
        getterMap.put(PropertyFileUtilFileKindEnum.ENUM_NAME, new PropertyFileUtilValueGetter(PropertyFileUtilFileKindEnum.ENUM_NAME));
    }
}

