/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.record;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jp.ecuacion.lib.core.record.item.EclibItem;

public interface EclibRecord {
    public EclibItem[] getItems();

    default public EclibItem getNewItem(String itemPropertyPath) {
        return new EclibItem(itemPropertyPath);
    }

    default public EclibItem getItem(String itemPropertyPath) {
        Map<String, EclibItem> map = Arrays.asList(this.getItems()).stream().collect(Collectors.toMap(e -> e.getItemPropertyPath(), e -> e));
        EclibItem field = map.get(itemPropertyPath);
        return field == null ? this.getNewItem(itemPropertyPath) : field;
    }

    default public EclibItem[] mergeItems(EclibItem[] fields1, EclibItem[] fields2) {
        ArrayList<EclibItem> list = new ArrayList<EclibItem>(Arrays.asList(fields1));
        List<String> propertyPath1List = Arrays.asList(fields1).stream().map(e -> e.getItemPropertyPath()).toList();
        for (String propertyPath2 : Arrays.asList(fields2).stream().map(e -> e.getItemPropertyPath()).toList()) {
            if (!propertyPath1List.contains(propertyPath2)) continue;
            throw new RuntimeException("'itemPropertyPath' of EclibItem[] duplicated with commonHtmlItems. key: " + propertyPath2);
        }
        list.addAll(Arrays.asList(fields2));
        return list.toArray(new EclibItem[list.size()]);
    }
}

