/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.exception.checked.ValidationAppException;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.lib.core.exception.unchecked.UncheckedAppException;
import jp.ecuacion.lib.core.jakartavalidation.bean.ConstraintViolationBean;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;

public class ExceptionUtil {
    public static final String SYSTEM_ERROR_OCCURED_SIGN = "=============== system error occurred ===============";
    private static final String RT = "\n";

    private ExceptionUtil() {
    }

    @Nonnull
    public static List<String> getExceptionMessage(@RequireNonnull Throwable throwable, boolean needsDetails) {
        return ExceptionUtil.getExceptionMessage(throwable, Locale.getDefault(), needsDetails);
    }

    @Nonnull
    public static List<String> getExceptionMessage(@RequireNonnull Throwable throwable, @Nullable Locale locale, boolean needsDetails) {
        return ExceptionUtil.getExceptionMessage(throwable, locale, needsDetails, true);
    }

    @Nonnull
    public static List<String> getExceptionMessage(@RequireNonnull Throwable throwable, @Nullable Locale locale, boolean needsDetails, boolean needsItemName) {
        ObjectsUtil.requireNonNull(throwable);
        locale = locale == null ? Locale.getDefault() : locale;
        ObjectsUtil.requireNonNull(needsDetails);
        ArrayList<Throwable> exList = new ArrayList<Throwable>();
        ArrayList<String> rtnList = new ArrayList<String>();
        if (throwable instanceof ConstraintViolationException) {
            ConstraintViolationException cve = (ConstraintViolationException)throwable;
            for (ConstraintViolation cv : cve.getConstraintViolations()) {
                exList.add(new ValidationAppException(cv));
            }
        } else {
            exList.add(throwable);
        }
        for (Throwable th : exList) {
            SingleAppException ex;
            if (th instanceof MultipleAppException) continue;
            if (th instanceof BizLogicAppException) {
                ex = (BizLogicAppException)th;
                rtnList.add(PropertyFileUtil.getMessage(locale, ((BizLogicAppException)ex).getMessageId(), ((BizLogicAppException)ex).getMessageArgs()));
                continue;
            }
            if (th instanceof ValidationAppException) {
                ex = (ValidationAppException)th;
                Object message = null;
                try {
                    ConstraintViolationBean bean = ((ValidationAppException)ex).getConstraintViolationBean();
                    HashMap<String, Object> map = new HashMap<String, Object>(bean.getParamMap());
                    Object object = message = needsItemName || ((ValidationAppException)ex).isMessageWithItemName() ? PropertyFileUtil.getValidationMessageWithItemName(locale, bean.getMessageTemplate(), map) : PropertyFileUtil.getValidationMessage(locale, bean.getMessageTemplate(), map);
                    if (((String)message).contains("{0}")) {
                        String itemNameKey;
                        String string = itemNameKey = bean.getItemNameKeys()[0] == null ? bean.getFieldPropertyPaths()[0] : bean.getItemNameKeys()[0];
                        if (itemNameKey.split("\\.").length > 2) {
                            while ((itemNameKey = itemNameKey.substring(itemNameKey.indexOf(".") + 1)).split("\\.").length != 2) {
                            }
                        }
                        if (PropertyFileUtil.hasItemName(itemNameKey)) {
                            itemNameKey = PropertyFileUtil.getItemName(locale, itemNameKey);
                        }
                        try {
                            message = MessageFormat.format((String)message, itemNameKey);
                        }
                        catch (IllegalArgumentException iae) {
                            String msg = "ExceptionUtil#getExceptionMessage: MessageFormat.format throws an IllegalArgumentException because message template has {x} with x not a number. (message template: " + (String)message + ")";
                            throw new EclibRuntimeException(msg, iae);
                        }
                    }
                    if (((ValidationAppException)ex).getMessagePrefix() != null) {
                        message = PropertyFileUtil.getStringFromArg(locale, ((ValidationAppException)ex).getMessagePrefix()) + (String)message;
                    }
                    if (((ValidationAppException)ex).getMessagePostfix() != null) {
                        message = (String)message + PropertyFileUtil.getStringFromArg(locale, ((ValidationAppException)ex).getMessagePostfix());
                    }
                }
                catch (MissingResourceException mre) {
                    message = ex.getMessage();
                }
                rtnList.add((String)(needsDetails ? (String)message + RT + ((ValidationAppException)ex).toString() : message));
                continue;
            }
            rtnList.add(th.getMessage());
        }
        return rtnList;
    }

    @Nonnull
    private static List<Throwable> serializeExceptions(@RequireNonnull Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        ExceptionUtil.recursivelySerializeException(throwable, list);
        return list;
    }

    private static void recursivelySerializeException(@RequireNonnull Throwable throwable, @RequireNonnull List<Throwable> arr) {
        ObjectsUtil.requireNonNull(arr.add(ObjectsUtil.requireNonNull(throwable)));
        if (throwable instanceof MultipleAppException) {
            for (AppException appException : ((MultipleAppException)throwable).getList()) {
                ExceptionUtil.recursivelySerializeException(appException, arr);
            }
        } else if (throwable.getCause() != null) {
            ExceptionUtil.recursivelySerializeException(throwable.getCause(), arr);
        }
    }

    @Nonnull
    public static List<Throwable> getExceptionListWithMessages(@RequireNonnull Throwable throwable) {
        ObjectsUtil.requireNonNull(throwable);
        ArrayList<Throwable> rtnList = new ArrayList<Throwable>();
        for (Throwable th : ExceptionUtil.serializeExceptions(throwable)) {
            if (th instanceof MultipleAppException) continue;
            if (th instanceof UncheckedAppException) {
                rtnList.add(((UncheckedAppException)th).getCause());
                continue;
            }
            if (!(th instanceof SingleAppException) && !(th instanceof EclibRuntimeException) && (th.getMessage() == null || th.getMessage().equals(""))) continue;
            rtnList.add(th);
        }
        return rtnList;
    }

    @Nonnull
    public static List<SingleAppException> getSingleAppExceptionList(@RequireNonnull AppException appException) {
        ObjectsUtil.requireNonNull(appException);
        ArrayList<SingleAppException> rtnList = new ArrayList<SingleAppException>();
        ExceptionUtil.serializeExceptions(appException).forEach(ex -> {
            if (ex instanceof SingleAppException) {
                rtnList.add((SingleAppException)ex);
            }
        });
        if (rtnList.isEmpty()) {
            throw new RuntimeException(appException);
        }
        return rtnList;
    }

    @Nonnull
    public static List<String> getAppExceptionMessageList(@RequireNonnull AppException appException, @Nullable Locale locale) {
        ArrayList<String> rtnList = new ArrayList<String>();
        ExceptionUtil.getSingleAppExceptionList(appException).stream().map(ex -> ExceptionUtil.getExceptionMessage(ex, locale, false)).forEach(list -> rtnList.addAll((Collection<String>)list));
        return rtnList;
    }

    @Nonnull
    public static List<String> getAppExceptionMessageList(@RequireNonnull AppException appException, @Nullable Locale locale, boolean needsItemName) {
        ArrayList<String> rtnList = new ArrayList<String>();
        ExceptionUtil.getSingleAppExceptionList(appException).stream().map(ex -> ExceptionUtil.getExceptionMessage(ex, locale, false, needsItemName)).forEach(list -> rtnList.addAll((Collection<String>)list));
        return rtnList;
    }

    @Nonnull
    public static String getErrLogShortString(@RequireNonnull Throwable throwable, @Nullable String additionalMessage, @Nullable Locale locale, int packagesShown) {
        return ExceptionUtil.getErrLogString(throwable, additionalMessage, locale, packagesShown);
    }

    @Nonnull
    public static String getErrLogString(@RequireNonnull Throwable throwable, @Nullable String additionalMessage, @Nullable Locale locale) {
        return ExceptionUtil.getErrLogString(throwable, additionalMessage, locale, null);
    }

    @Nonnull
    private static String getErrLogString(@RequireNonnull Throwable throwable, @Nullable String additionalMessage, @Nullable Locale locale, @Nullable Integer packagesShown) {
        ObjectsUtil.requireNonNull(throwable);
        locale = locale == null ? Locale.getDefault() : locale;
        StringBuilder sb = new StringBuilder();
        sb.append("=============== system error occurred ===============\n");
        if (additionalMessage != null) {
            sb.append(additionalMessage + RT);
            sb.append(RT);
        }
        sb.append(RT);
        ExceptionUtil.getMessageAndStackTraceStringRecursively(sb, throwable, locale, packagesShown);
        return sb.toString();
    }

    public static void getMessageAndStackTraceStringRecursively(StringBuilder sb, Throwable th, Locale locale, Integer packagesShown) {
        ExceptionUtil.getMessageAndStackTraceString(sb, th, locale, packagesShown);
        if (th.getCause() != null) {
            ExceptionUtil.getMessageAndStackTraceStringRecursively(sb, th.getCause(), locale, packagesShown);
        }
    }

    private static void getMessageAndStackTraceString(StringBuilder sb, Throwable th, Locale locale, Integer packagesShown) {
        locale = locale == null ? Locale.ENGLISH : locale;
        String errMsg = ExceptionUtil.getExceptionMessage(th, locale, true).toString();
        sb.append(th.getClass().getCanonicalName() + " " + errMsg + RT);
        ExceptionUtil.getStackTraceString(sb, th, packagesShown);
    }

    private static void getStackTraceString(StringBuilder sb, Throwable th, Integer packagesShown) {
        for (StackTraceElement ste : th.getStackTrace()) {
            String[] spl = ste.getClassName().split("\\.");
            Object packageAndClass = ste.getClassName();
            if (packagesShown != null) {
                Object packages = "";
                for (int i = 0; i < packagesShown; ++i) {
                    if (spl.length <= i) continue;
                    packages = (String)packages + spl[i] + (spl.length - 1 == i ? "" : ".");
                }
                packageAndClass = (String)packages + (spl.length > packagesShown ? "." : "");
            }
            sb.append("\tat " + (String)packageAndClass + "." + ste.getMethodName() + "(" + ste.getFileName() + ":" + ste.getLineNumber() + ")\n");
        }
    }
}

