/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.jakartavalidation.bean;

import jakarta.annotation.Nonnull;
import jakarta.validation.ConstraintViolation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.lib.core.jakartavalidation.validator.ItemNameKeyClass;
import jp.ecuacion.lib.core.jakartavalidation.validator.PlacedAtClass;
import jp.ecuacion.lib.core.jakartavalidation.validator.enums.ConditionValuePattern;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.lib.core.util.internal.ReflectionUtil;
import org.apache.commons.lang3.StringUtils;

public class ConstraintViolationBean
extends ReflectionUtil {
    private ConstraintViolation<?> cv;
    private String message;
    private String[] fieldPropertyPaths;
    private String validatorClass;
    private String rootClassName;
    private String messageTemplate;
    private String annotationDescriptionString;
    private String[] itemNameKeys;
    @Nonnull
    private Map<String, Object> paramMap;
    private static final String CONDITIONAL_VALIDATOR_PREFIX = "jp.ecuacion.lib.core.jakartavalidation.validator.Conditional";

    public ConstraintViolationBean(ConstraintViolation<?> cv) {
        this.cv = cv;
        this.message = cv.getMessage();
        this.validatorClass = cv.getConstraintDescriptor().getAnnotation().annotationType().getName();
        this.rootClassName = cv.getRootBeanClass().getName();
        this.annotationDescriptionString = cv.getConstraintDescriptor().getAnnotation().toString();
        this.messageTemplate = cv.getMessageTemplate();
        if (this.messageTemplate.startsWith("{")) {
            this.messageTemplate = this.messageTemplate.replace("{", "").replace("}", "");
        }
        this.paramMap = cv.getConstraintDescriptor().getAttributes() == null ? new HashMap<String, Object>() : new HashMap(cv.getConstraintDescriptor().getAttributes());
        this.putAdditionalParamsToParamMap(cv);
    }

    public ConstraintViolationBean(String message, String validatorClass, String rootClassName, String propertyPath) {
        this.message = message;
        this.validatorClass = validatorClass;
        this.rootClassName = rootClassName;
        this.messageTemplate = validatorClass + ".message";
        this.fieldPropertyPaths = new String[]{propertyPath};
        this.itemNameKeys = new String[]{propertyPath};
        this.paramMap = new HashMap<String, Object>();
        this.annotationDescriptionString = "";
    }

    private Optional<String> getItemNameKeyClassFromAnnotation(boolean isClassValidator, Object leafBean, String propertyPath) {
        Class<?> modifiedLeafBeanClass = leafBean.getClass();
        try {
            Optional<ItemNameKeyClass> an;
            if (!isClassValidator) {
                String value;
                String fieldName = propertyPath.split("\\.")[propertyPath.split("\\.").length - 1];
                Field field = ConstraintViolationBean.getField(fieldName, leafBean.getClass());
                ItemNameKeyClass an2 = field.getAnnotation(ItemNameKeyClass.class);
                String string = value = an2 == null ? null : an2.value();
                if (value != null) {
                    return Optional.of(value);
                }
            } else {
                String tmpPp = propertyPath;
                while (!StringUtils.isEmpty((CharSequence)tmpPp)) {
                    String fieldName = tmpPp.contains(".") ? tmpPp.substring(0, tmpPp.indexOf(".")) : tmpPp;
                    modifiedLeafBeanClass = ConstraintViolationBean.getField(fieldName, modifiedLeafBeanClass).getType();
                    tmpPp = tmpPp.contains(".") ? tmpPp.substring(tmpPp.indexOf(".") + 1) : "";
                }
            }
            return Optional.ofNullable((an = ConstraintViolationBean.searchAnnotationPlacedAtClass(modifiedLeafBeanClass, ItemNameKeyClass.class)).isPresent() ? an.get().value() : null);
        }
        catch (Exception ex) {
            throw new EclibRuntimeException(ex);
        }
    }

    private void putAdditionalParamsToParamMap(ConstraintViolation<?> cv) {
        String propertyPath = cv.getPropertyPath().toString();
        this.paramMap.put("leafClassName", this.getLeafClassName());
        this.paramMap.put("invalidValue", this.getInvalidValue());
        this.paramMap.put("annotation", this.getAnnotation());
        boolean isClassValidator = cv.getConstraintDescriptor().getAnnotation().annotationType().getAnnotation(PlacedAtClass.class) != null;
        String defaultItemNameKeyClass = null;
        String[] propertyPaths = null;
        ArrayList<CallSite> itemNameKeyList = new ArrayList<CallSite>();
        if (isClassValidator) {
            for (String fieldPropertyPath : propertyPaths = (String[])this.paramMap.get("propertyPath")) {
                Optional<String> itemNameKeyClassFromAnnotation = this.getItemNameKeyClassFromAnnotation(isClassValidator, cv.getLeafBean(), fieldPropertyPath.contains(".") ? fieldPropertyPath.substring(0, fieldPropertyPath.lastIndexOf(".")) : "");
                defaultItemNameKeyClass = StringUtils.isEmpty((CharSequence)propertyPath) ? this.rootClassName.split("\\.")[this.rootClassName.split("\\.").length - 1] : propertyPath.split("\\.")[propertyPath.split("\\.").length - 1];
                String itemNameKey = this.getFinalItemNameKeyClass(itemNameKeyClassFromAnnotation, defaultItemNameKeyClass) + "." + (fieldPropertyPath.contains(".") ? fieldPropertyPath.substring(fieldPropertyPath.lastIndexOf(".") + 1) : fieldPropertyPath);
                itemNameKeyList.add((CallSite)((Object)itemNameKey));
            }
            String conditionPropertyPath = (String)this.paramMap.get("conditionPropertyPath");
            Optional<String> itemNameKeyClassFromAnnotation = this.getItemNameKeyClassFromAnnotation(isClassValidator, cv.getLeafBean(), conditionPropertyPath);
            String newValue = this.getFinalItemNameKeyClass(itemNameKeyClassFromAnnotation, defaultItemNameKeyClass) + "." + conditionPropertyPath;
            this.paramMap.put("conditionPropertyPathItemNameKey", newValue);
            List<String> list = Arrays.asList(propertyPaths).stream().map(field -> propertyPath + "." + field).toList();
            this.fieldPropertyPaths = list.toArray(new String[list.size()]);
        } else {
            Optional<String> itemNameKeyClassFromAnnotation = this.getItemNameKeyClassFromAnnotation(isClassValidator, cv.getLeafBean(), cv.getPropertyPath().toString());
            defaultItemNameKeyClass = propertyPath.split("\\.").length > 1 ? propertyPath.split("\\.")[propertyPath.split("\\.").length - 2] : this.rootClassName.split("\\.")[this.rootClassName.split("\\.").length - 1];
            String field2 = propertyPath.split("\\.")[propertyPath.split("\\.").length - 1];
            String itemNameKey = this.getFinalItemNameKeyClass(itemNameKeyClassFromAnnotation, defaultItemNameKeyClass) + "." + field2;
            itemNameKeyList.add((CallSite)((Object)itemNameKey));
            this.fieldPropertyPaths = new String[]{propertyPath};
        }
        this.itemNameKeys = itemNameKeyList.toArray(new String[itemNameKeyList.size()]);
        this.paramMap.put("itemNameKeys", this.itemNameKeys);
        if (this.getAnnotation().startsWith(CONDITIONAL_VALIDATOR_PREFIX)) {
            ConditionValuePattern conditionPtn = (ConditionValuePattern)((Object)this.paramMap.get("conditionPattern"));
            this.paramMap.put("conditionPattern", (Object)conditionPtn);
            String valuesOfConditionPropertyPathToValidate = null;
            if (conditionPtn == ConditionValuePattern.valueOfPropertyPath) {
                Object obj = ConstraintViolationBean.getFieldValue((String)this.paramMap.get("conditionValuePropertyPath"), this.getInstance());
                if (obj instanceof Object[]) {
                    List<String> strList = Arrays.asList(obj).stream().map(o -> o.toString()).toList();
                    valuesOfConditionPropertyPathToValidate = StringUtil.getCsvWithSpace(strList.toArray(new String[strList.size()]));
                } else {
                    valuesOfConditionPropertyPathToValidate = String.valueOf(obj);
                }
            } else if (conditionPtn == ConditionValuePattern.string) {
                String[] strs = (String[])this.paramMap.get("conditionValueString");
                valuesOfConditionPropertyPathToValidate = StringUtil.getCsvWithSpace(strs);
            }
            String valueOfConditionValuePropertyPathForDisplay = (String)this.paramMap.get("valueOfConditionValuePropertyPathForDisplay");
            if (!valueOfConditionValuePropertyPathForDisplay.equals("")) {
                String[] strs = (String[])ConstraintViolationBean.getFieldValue(valueOfConditionValuePropertyPathForDisplay, this.getInstance());
                valuesOfConditionPropertyPathToValidate = StringUtil.getCsvWithSpace(strs);
            }
            this.paramMap.put("valuesOfConditionFieldToValidate", valuesOfConditionPropertyPathToValidate);
            boolean bl = this.getAnnotation().endsWith("ConditionalEmpty") && (Boolean)this.paramMap.get("notEmptyWhenConditionNotSatisfied") != false || this.getAnnotation().endsWith("ConditionalNotEmpty") && (Boolean)this.paramMap.get("emptyWhenConditionNotSatisfied") != false;
            this.paramMap.put("validatesWhenConditionNotSatisfied", bl);
        }
    }

    private String getFinalItemNameKeyClass(Optional<String> itemNameKeyClassFromAnnotation, String defaultItemNameKeyClass) {
        String itemNameKeyClass = itemNameKeyClassFromAnnotation.orElse(defaultItemNameKeyClass);
        return itemNameKeyClass.split("\\$")[itemNameKeyClass.split("\\$").length - 1];
    }

    public String getMessage() {
        return this.message;
    }

    public String getValidatorClass() {
        return this.validatorClass;
    }

    public String getAnnotationDescriptionString() {
        return this.annotationDescriptionString;
    }

    public String getAnnotation() {
        return this.cv.getConstraintDescriptor().getAnnotation().annotationType().getCanonicalName();
    }

    public Map<String, Object> getAnnotationAttributes() {
        return this.cv.getConstraintDescriptor().getAttributes();
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public String getRootClassName() {
        return this.rootClassName;
    }

    public String getLeafClassName() {
        return this.cv.getLeafBean().getClass().getName();
    }

    public String getInvalidValue() {
        return this.cv.getInvalidValue() == null ? "null" : this.cv.getInvalidValue().toString();
    }

    @Nonnull
    public String getMessageId() {
        return this.getAnnotation();
    }

    public Object getInstance() {
        return this.cv.getLeafBean();
    }

    public String[] getItemNameKeys() {
        return this.itemNameKeys;
    }

    @Nonnull
    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }

    public String[] getFieldPropertyPaths() {
        return this.fieldPropertyPaths;
    }
}

