/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.lib.core.util.internal.PropertyFileUtilFileKindEnum;
import jp.ecuacion.lib.core.util.internal.PropertyFileUtilValueGetter;

public class PropertyFileUtil {
    private static Map<PropertyFileUtilFileKindEnum, PropertyFileUtilValueGetter> getterMap = new HashMap<PropertyFileUtilFileKindEnum, PropertyFileUtilValueGetter>();

    private PropertyFileUtil() {
    }

    @Nonnull
    public static String getApplication(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.APPLICATION).getProp(key, null);
    }

    public static boolean hasApplication(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.APPLICATION).hasProp(key);
    }

    @Nullable
    public static String getApplicationOrElse(@RequireNonnull String key, String defaultValue) {
        if (getterMap.get((Object)PropertyFileUtilFileKindEnum.APPLICATION).hasProp(key)) {
            return getterMap.get((Object)PropertyFileUtilFileKindEnum.APPLICATION).getProp(key, null);
        }
        return defaultValue;
    }

    @Nonnull
    public static String getMessage(@RequireNonnull String key, String ... args) {
        return PropertyFileUtil.getMessage(null, key, args);
    }

    @Nonnull
    public static String getMessage(@Nullable Locale locale, @RequireNonnull String key, String ... args) {
        String msgStr = getterMap.get((Object)PropertyFileUtilFileKindEnum.MESSAGES).getProp(locale, key, null);
        return args.length == 0 ? msgStr : MessageFormat.format(msgStr, args);
    }

    @Nonnull
    public static String getMessage(@RequireNonnull String key, @RequireNonnull Arg[] args) {
        return PropertyFileUtil.getMessage(null, key, args);
    }

    @Nonnull
    public static String getMessage(@Nullable Locale locale, @RequireNonnull String key, @RequireNonnull Arg[] args) {
        ArrayList list = new ArrayList();
        Arrays.asList(args).stream().forEach(arg -> list.add(PropertyFileUtil.getStringFromArg(locale, arg)));
        return PropertyFileUtil.getMessage(locale, key, list.toArray(new String[list.size()]));
    }

    public static boolean hasMessage(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.MESSAGES).hasProp(key);
    }

    @Nonnull
    public static String getString(@RequireNonnull String key, String ... args) {
        List<Arg> list = Arrays.asList(args).stream().map(str -> Arg.string(str)).toList();
        return PropertyFileUtil.getString(key, list.toArray(new Arg[list.size()]));
    }

    @Nonnull
    public static String getString(@RequireNonnull String key, @RequireNonnull Arg[] args) {
        String msgStr = getterMap.get((Object)PropertyFileUtilFileKindEnum.STRINGS).getProp(key, null);
        return args.length == 0 ? msgStr : MessageFormat.format(msgStr, args);
    }

    public static boolean hasString(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.STRINGS).hasProp(key);
    }

    @Nonnull
    public static String getItemName(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ITEM_NAMES).getProp(null, key, null);
    }

    @Nonnull
    public static String getItemName(@Nullable Locale locale, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ITEM_NAMES).getProp(locale, key, null);
    }

    public static boolean hasItemName(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ITEM_NAMES).hasProp(key);
    }

    @Nonnull
    public static String getEnumName(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ENUM_NAMES).getProp(null, key, null);
    }

    @Nonnull
    public static String getEnumName(@Nullable Locale locale, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ENUM_NAMES).getProp(locale, key, null);
    }

    public static boolean hasEnumName(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ENUM_NAMES).hasProp(key);
    }

    @Nonnull
    public static String getValidationMessage(@RequireNonnull String key, Map<String, Object> argMap) {
        return PropertyFileUtil.getValidationMessage(null, key, argMap);
    }

    @Nonnull
    public static String getValidationMessage(@Nullable Locale locale, @RequireNonnull String key, @Nullable Map<String, Object> argMap) {
        String message = getterMap.get((Object)PropertyFileUtilFileKindEnum.VALIDATION_MESSAGES).getProp(locale, key, argMap);
        return PropertyFileUtil.substituteArgsToValidationMessages(locale, message, argMap);
    }

    @Nonnull
    public static String getValidationMessageWithItemName(@RequireNonnull String key, @Nullable Map<String, Object> argMap) {
        return PropertyFileUtil.getValidationMessageWithItemName(null, key, argMap);
    }

    @Nonnull
    public static String getValidationMessageWithItemName(@Nullable Locale locale, @RequireNonnull String key, @Nullable Map<String, Object> argMap) {
        String message = getterMap.get((Object)PropertyFileUtilFileKindEnum.VALIDATION_MESSAGES_WITH_ITEM_NAMES).getProp(locale, key, argMap);
        return PropertyFileUtil.substituteArgsToValidationMessages(locale, message, argMap);
    }

    @Nonnull
    private static String substituteArgsToValidationMessages(@Nullable Locale locale, @RequireNonnull String message, @Nullable Map<String, Object> argMap) {
        String newValue;
        String newKey;
        String key;
        argMap = argMap == null ? new HashMap<String, String>() : argMap;
        String argAnnotationValue = (String)argMap.get("annotation");
        String annotation = "jp.ecuacion.lib.core.jakartavalidation.validator.PatternWithDescription";
        if (argAnnotationValue != null && argAnnotationValue.equals(annotation)) {
            key = "descriptionId";
            newKey = "patternDescription";
            newValue = PropertyFileUtil.getValidationMessagePatternDescription(locale, (String)argMap.get(key));
            argMap.put(newKey, newValue);
        }
        annotation = "jp.ecuacion.lib.core.jakartavalidation.validator.Conditional";
        if (argAnnotationValue != null && argAnnotationValue.startsWith(annotation)) {
            key = "itemNameKeys";
            newKey = "itemName";
            String[] itemNameKeys = (String[])argMap.get(key);
            ArrayList<String> itemNameList = new ArrayList<String>();
            for (String itemNameKey : itemNameKeys) {
                itemNameList.add(PropertyFileUtil.getItemName(locale, itemNameKey));
            }
            argMap.put(newKey, StringUtil.getCsvWithSpace(itemNameList));
            String val = (String)argMap.get("conditionPropertyPathItemNameKey");
            argMap.put("conditionPropertyPathDisplayName", val == null ? null : PropertyFileUtil.getItemName(locale, val));
            key = "conditionPattern";
            newKey = "conditionValueDescription";
            newValue = PropertyFileUtil.getMessage(locale, annotation + ".messagePart." + String.valueOf(argMap.get(key)), (String)argMap.get("valuesOfConditionFieldToValidate"));
            argMap.put(newKey, newValue);
            newKey = "validatesWhenConditionNotSatisfiedDescription";
            newValue = (Boolean)argMap.get("validatesWhenConditionNotSatisfied") != false ? PropertyFileUtil.getMessage(locale, String.valueOf(argMap.get("annotation")) + ".messagePart.validatesWhenConditionNotSatisfied", (String)argMap.get("valuesOfConditionFieldToValidate")) : "";
            argMap.put(newKey, newValue);
        }
        String rtnMessage = message;
        for (Map.Entry entry : argMap.entrySet()) {
            rtnMessage = rtnMessage.replace("{" + (String)entry.getKey() + "}", entry.getValue() == null ? "''" : entry.getValue().toString().replace("{", "'{'").replace("}", "'}'"));
        }
        return rtnMessage;
    }

    @Nonnull
    public static String getValidationMessagePatternDescription(@RequireNonnull String key) {
        return PropertyFileUtil.getValidationMessagePatternDescription(null, key);
    }

    @Nonnull
    public static String getValidationMessagePatternDescription(@Nullable Locale locale, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.VALIDATION_MESSAGES_PATTERN_DESCRIPTIONS).getProp(locale, key, null);
    }

    @Nonnull
    public static String get(@RequireNonnull String propertyUtilFileKind, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.valueOf(propertyUtilFileKind.toUpperCase())).getProp(null, key, null);
    }

    @Nonnull
    public static String get(@RequireNonnull String propertyUtilFileKind, @Nullable Locale locale, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.valueOf(propertyUtilFileKind.toUpperCase())).getProp(locale, key, null);
    }

    public static boolean has(@RequireNonnull String propertyUtilFileKind, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.valueOf(propertyUtilFileKind.toUpperCase())).hasProp(key);
    }

    public static void addResourceBundlePostfix(@RequireNonnull String postfix) {
        PropertyFileUtilValueGetter.addToDynamicPostfixList(postfix);
    }

    @Nonnull
    public static String getStringFromArg(@Nullable Locale locale, @RequireNonnull Arg arg) {
        return arg.isMessageId() ? PropertyFileUtil.getMessage(locale, arg.getArgString(), arg.messageArgs) : arg.getArgString();
    }

    static {
        for (PropertyFileUtilFileKindEnum anEnum : PropertyFileUtilFileKindEnum.values()) {
            getterMap.put(anEnum, new PropertyFileUtilValueGetter(anEnum));
        }
    }

    public static class Arg {
        private boolean isMessageId;
        private String argString;
        private Arg[] messageArgs;

        public static Arg string(String argString) {
            return new Arg(false, argString, new Arg[0]);
        }

        public static Arg[] strings(String ... argStrings) {
            return Arrays.asList(argStrings).stream().map(arg -> Arg.string(arg)).toList().toArray(new Arg[argStrings.length]);
        }

        public static Arg message(String messageId) {
            return new Arg(true, messageId, new Arg[0]);
        }

        public static Arg message(String messageId, String ... stringArgs) {
            List<String> stringArgList = Arrays.asList(stringArgs);
            Arg[] args = stringArgList.stream().map(str -> Arg.string(str)).toList().toArray(new Arg[stringArgList.size()]);
            return new Arg(true, messageId, args);
        }

        public static Arg message(String messageId, Arg ... messageArgs) {
            return new Arg(true, messageId, messageArgs);
        }

        private Arg(boolean isMessageId, String argString, Arg ... messageArgs) {
            this.isMessageId = isMessageId;
            this.argString = argString;
            this.messageArgs = messageArgs;
        }

        public String getArgString() {
            return this.argString;
        }

        public boolean isMessageId() {
            return this.isMessageId;
        }

        public Arg[] getMessageArgs() {
            return this.messageArgs;
        }
    }
}

