/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.jakartavalidation.validator.internal;

import jakarta.validation.ConstraintValidatorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.lib.core.jakartavalidation.validator.enums.ConditionPattern;
import jp.ecuacion.lib.core.util.internal.ReflectionUtil;

public abstract class ConditionalValidator
extends ReflectionUtil {
    private String[] propertyPath;
    private String conditionPropertyPath;
    private ConditionPattern conditionPattern;
    private String[] conditionValueString;
    private String conditionValuePropertyPath;
    private boolean validatesWhenConditionNotSatisfied;
    public static final String VALIDATION_TARGET_FIELD = "validationTargetPropertyPath";
    public static final String CONDITION_PROPERTY_PATH = "conditionPropertyPath";
    public static final String CONDITION_PROPERTY_PATH_ITEM_NAME_KEY = "conditionPropertyPathItemNameKey";
    public static final String CONDITION_PROPERTY_PATH_DISPLAY_NAME = "conditionPropertyPathDisplayName";
    public static final String CONDITION_PATTERN = "conditionPattern";
    public static final String CONDITION_VALUE_STRING = "conditionValueString";
    public static final String CONDITION_VALUE_PROPERTY_PATH = "conditionValuePropertyPath";
    public static final String VALUE_OF_CONDITION_VALUE_PROPERTY_PATH_FOR_DISPLAY = "valueOfConditionValuePropertyPathForDisplay";
    public static final String VALIDATES_WHEN_CONDITION_NOT_SATISFIED_EMPTY = "notEmptyWhenConditionNotSatisfied";
    public static final String VALIDATES_WHEN_CONDITION_NOT_SATISFIED_NOT_EMPTY = "emptyWhenConditionNotSatisfied";
    public static final String VALUE_OF_CONDITION_FIELD_TO_VALIDATE = "valuesOfConditionFieldToValidate";
    public static final String VALIDATES_WHEN_CONDITION_NOT_SATISFIED = "validatesWhenConditionNotSatisfied";

    public void initialize(String[] propertyPath, String conditionPropertyPath, ConditionPattern conditionPattern, String[] conditionValueString, String conditionValuePropertyPath, boolean validatesWhenConditionNotSatisfied) {
        this.propertyPath = propertyPath;
        this.conditionPropertyPath = conditionPropertyPath;
        this.conditionPattern = conditionPattern;
        this.conditionValueString = conditionValueString;
        this.conditionValuePropertyPath = conditionValuePropertyPath;
        this.validatesWhenConditionNotSatisfied = validatesWhenConditionNotSatisfied;
    }

    protected abstract boolean isValid(Object var1);

    public boolean isValid(Object instance, ConstraintValidatorContext context) {
        boolean satisfiesCondition = this.getSatisfiesCondition(instance);
        List<Object> valueOfFieldList = Arrays.asList(this.propertyPath).stream().map(f -> ConditionalValidator.getFieldValue(f, instance)).toList();
        for (Object valueOfField : valueOfFieldList) {
            boolean result = this.isValidForSingleValueOfField(valueOfField, satisfiesCondition);
            if (result) continue;
            return false;
        }
        return true;
    }

    private boolean isValidForSingleValueOfField(Object valueOfField, boolean satisfiesCondition) {
        if (satisfiesCondition) {
            return this.isValid(valueOfField);
        }
        if (this.validatesWhenConditionNotSatisfied) {
            return this.isValidWhenConditionNotSatisfied(valueOfField);
        }
        return true;
    }

    boolean getSatisfiesCondition(Object instance) {
        Object valueOfConditionField = ConditionalValidator.getFieldValue(this.conditionPropertyPath, instance);
        if (this.conditionPattern == ConditionPattern.valueOfConditionPropertyPathIsEmpty || this.conditionPattern == ConditionPattern.valueOfConditionPropertyPathIsNotEmpty) {
            boolean isEmpty;
            this.conditionValueStringMustNotSet();
            this.conditionValueFieldMustNotSet();
            boolean bl = isEmpty = valueOfConditionField == null || valueOfConditionField instanceof String && ((String)valueOfConditionField).equals("");
            if (isEmpty && this.conditionPattern == ConditionPattern.valueOfConditionPropertyPathIsEmpty || !isEmpty && this.conditionPattern == ConditionPattern.valueOfConditionPropertyPathIsNotEmpty) {
                return true;
            }
        } else if (this.conditionPattern == ConditionPattern.valueOfConditionPropertyPathIsEqualToValueOf || this.conditionPattern == ConditionPattern.valueOfConditionPropertyPathIsNotEqualToValueOf) {
            boolean contains;
            Object firstValueOfConditionValueField;
            this.conditionValueStringMustNotSet();
            Object valueOfConditionValueField = ConditionalValidator.getFieldValue(this.conditionValuePropertyPath, instance);
            ArrayList<Object> valueListOfConditionValueField = new ArrayList<Object>();
            if (valueOfConditionValueField instanceof Object[]) {
                for (Object val : (Object[])valueOfConditionValueField) {
                    valueListOfConditionValueField.add(val);
                }
            } else {
                valueListOfConditionValueField.add(valueOfConditionValueField);
            }
            List<Object> nonnullList = valueListOfConditionValueField.stream().filter(v -> v != null).toList();
            Object object = firstValueOfConditionValueField = nonnullList.size() == 0 ? null : nonnullList.get(0);
            if (valueOfConditionField != null && firstValueOfConditionValueField != null) {
                Class<?> valueOfCf = valueOfConditionField.getClass();
                Class<?> firstValueOfCvfList = firstValueOfConditionValueField.getClass();
                if (!firstValueOfCvfList.isAssignableFrom(valueOfCf)) {
                    throw new EclibRuntimeException("Datatype not match. valueOfConditionField: " + String.valueOf(valueOfConditionField) + ", valueListOfConditionValueField.get(0): " + String.valueOf(firstValueOfConditionValueField));
                }
            }
            valueListOfConditionValueField.replaceAll(x -> x == null ? "[null]" : x);
            boolean bl = contains = valueOfConditionField == null && valueListOfConditionValueField.contains("[null]") || valueOfConditionField != null && valueListOfConditionValueField.contains(valueOfConditionField);
            if (contains && this.conditionPattern == ConditionPattern.valueOfConditionPropertyPathIsEqualToValueOf || !contains && this.conditionPattern == ConditionPattern.valueOfConditionPropertyPathIsNotEqualToValueOf) {
                return true;
            }
        } else {
            this.conditionValueFieldMustNotSet();
            if (valueOfConditionField == null) {
                valueOfConditionField = "[null]";
            }
            if (!(valueOfConditionField instanceof String)) {
                throw new EclibRuntimeException("When 'conditionValue' is not null, 'validationConditionField' must be String.");
            }
            boolean contains = Arrays.asList(this.conditionValueString).contains(valueOfConditionField);
            if (contains && this.conditionPattern == ConditionPattern.stringValueOfConditionPropertyPathIsEqualTo || !contains && this.conditionPattern == ConditionPattern.stringValueOfConditionPropertyPathIsNotEqualTo) {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidWhenConditionNotSatisfied(Object valueOfField) {
        return true;
    }

    private void conditionValueFieldMustNotSet() {
        if (!Arrays.asList(this.conditionValuePropertyPath).contains("[null]")) {
            throw new EclibRuntimeException("You cannot set 'conditionValueField' when howToDetermineConditionIsValid is not either 'valueOfConditionFieldIsEqualToValueOf' or 'valueOfConditionFieldIsNotEqualToValueOf'.");
        }
    }

    private void conditionValueStringMustNotSet() {
        if (!Arrays.asList(this.conditionValueString).contains("[null]")) {
            throw new EclibRuntimeException("You cannot set 'conditionValueString' when howToDetermineConditionIsValid is not either 'stringValueOfConditionFieldIsEqualTo' or 'stringValueOfConditionFieldIsNotEqualTo'.");
        }
    }
}

