/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.jakartavalidation.bean;

import jakarta.annotation.Nonnull;
import jakarta.validation.ConstraintViolation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.lib.core.jakartavalidation.validator.ItemKindIdClass;
import jp.ecuacion.lib.core.jakartavalidation.validator.PlacedAtClass;
import jp.ecuacion.lib.core.jakartavalidation.validator.enums.ConditionPattern;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.lib.core.util.internal.ReflectionUtil;
import org.apache.commons.lang3.StringUtils;

public class ConstraintViolationBean
extends ReflectionUtil {
    private ConstraintViolation<?> cv;
    private String message;
    private String propertyPath;
    private String[] fieldPropertyPaths;
    private String validatorClass;
    private String rootClassName;
    private String messageTemplate;
    private String annotationDescriptionString;
    private String[] itemKindIds;
    @Nonnull
    private Map<String, Object> paramMap;
    private static final String CONDITIONAL_VALIDATOR_PREFIX = "jp.ecuacion.lib.core.jakartavalidation.validator.Conditional";

    public ConstraintViolationBean(ConstraintViolation<?> cv) {
        this.cv = cv;
        this.message = cv.getMessage();
        this.propertyPath = cv.getPropertyPath().toString();
        this.validatorClass = cv.getConstraintDescriptor().getAnnotation().annotationType().getName();
        this.rootClassName = cv.getRootBeanClass().getName();
        this.annotationDescriptionString = cv.getConstraintDescriptor().getAnnotation().toString();
        this.messageTemplate = cv.getMessageTemplate();
        if (this.messageTemplate.startsWith("{")) {
            this.messageTemplate = this.messageTemplate.replace("{", "").replace("}", "");
        }
        this.paramMap = cv.getConstraintDescriptor().getAttributes() == null ? new HashMap<String, Object>() : new HashMap(cv.getConstraintDescriptor().getAttributes());
        this.putAdditionalParamsToParamMap(cv);
    }

    public ConstraintViolationBean(String message, String validatorClass, String rootClassName, String itemKindId) {
        this.message = message;
        this.validatorClass = validatorClass;
        this.rootClassName = rootClassName;
        this.messageTemplate = validatorClass + ".message";
        this.itemKindIds = new String[]{itemKindId};
        this.propertyPath = itemKindId;
        this.fieldPropertyPaths = new String[]{itemKindId};
        this.paramMap = new HashMap<String, Object>();
        this.annotationDescriptionString = "";
    }

    private Optional<String> getItemKindIdClassFromAnnotation(boolean isClassValidator, Object leafBean, String propertyPath) {
        Object modifiedLeafBean = leafBean;
        try {
            Optional<ItemKindIdClass> an;
            if (!isClassValidator) {
                String value;
                String fieldName = propertyPath.split("\\.")[propertyPath.split("\\.").length - 1];
                Field field = (Field)ConstraintViolationBean.getField(fieldName, modifiedLeafBean).getLeft();
                ItemKindIdClass an2 = field.getAnnotation(ItemKindIdClass.class);
                String string = value = an2 == null ? null : an2.value();
                if (value != null) {
                    return Optional.of(value);
                }
            } else {
                String tmpPp = propertyPath;
                while (!StringUtils.isEmpty((CharSequence)tmpPp)) {
                    String fieldName = tmpPp.contains(".") ? tmpPp.substring(0, tmpPp.indexOf(".")) : tmpPp;
                    tmpPp = tmpPp.contains(".") ? tmpPp.substring(tmpPp.indexOf(".") + 1) : "";
                    modifiedLeafBean = ConstraintViolationBean.getFieldValue(fieldName, modifiedLeafBean);
                }
            }
            return Optional.ofNullable((an = ConstraintViolationBean.searchAnnotationPlacedAtClass(modifiedLeafBean, ItemKindIdClass.class)).isPresent() ? an.get().value() : null);
        }
        catch (Exception ex) {
            throw new EclibRuntimeException(ex);
        }
    }

    private void putAdditionalParamsToParamMap(ConstraintViolation<?> cv) {
        this.paramMap.put("leafClassName", this.getLeafClassName());
        this.paramMap.put("invalidValue", this.getInvalidValue());
        this.paramMap.put("annotation", this.getAnnotation());
        boolean isClassValidator = cv.getConstraintDescriptor().getAnnotation().annotationType().getAnnotation(PlacedAtClass.class) != null;
        String defaultItemKindIdClass = null;
        String[] propertyPaths = null;
        ArrayList<CallSite> itemKindIdList = new ArrayList<CallSite>();
        if (isClassValidator) {
            for (String fieldPropertyPath : propertyPaths = (String[])this.paramMap.get("propertyPath")) {
                Optional<String> itemKindIdClassFromAnnotation = this.getItemKindIdClassFromAnnotation(isClassValidator, cv.getLeafBean(), fieldPropertyPath.contains(".") ? fieldPropertyPath.substring(0, fieldPropertyPath.lastIndexOf(".")) : "");
                defaultItemKindIdClass = StringUtils.isEmpty((CharSequence)this.propertyPath) ? this.rootClassName.split("\\.")[this.rootClassName.split("\\.").length - 1] : this.propertyPath.split("\\.")[this.propertyPath.split("\\.").length - 1];
                String itemKindId = this.getFinalItemKindIdClass(itemKindIdClassFromAnnotation, defaultItemKindIdClass) + "." + (fieldPropertyPath.contains(".") ? fieldPropertyPath.substring(fieldPropertyPath.lastIndexOf(".") + 1) : fieldPropertyPath);
                itemKindIdList.add((CallSite)((Object)itemKindId));
            }
            String conditionPropertyPath = (String)this.paramMap.get("conditionPropertyPath");
            Optional<String> itemKindIdClassFromAnnotation = this.getItemKindIdClassFromAnnotation(isClassValidator, cv.getLeafBean(), conditionPropertyPath);
            String newValue = this.getFinalItemKindIdClass(itemKindIdClassFromAnnotation, defaultItemKindIdClass) + "." + conditionPropertyPath;
            this.paramMap.put("conditionPropertyPathItemKindId", newValue);
            List<String> list = Arrays.asList(propertyPaths).stream().map(field -> this.propertyPath + "." + field).toList();
            this.fieldPropertyPaths = list.toArray(new String[list.size()]);
        } else {
            Optional<String> itemKindIdClassFromAnnotation = this.getItemKindIdClassFromAnnotation(isClassValidator, cv.getLeafBean(), cv.getPropertyPath().toString());
            defaultItemKindIdClass = this.propertyPath.split("\\.").length > 1 ? this.propertyPath.split("\\.")[this.propertyPath.split("\\.").length - 2] : this.rootClassName.split("\\.")[this.rootClassName.split("\\.").length - 1];
            String field2 = this.propertyPath.split("\\.")[this.propertyPath.split("\\.").length - 1];
            String itemKindId = this.getFinalItemKindIdClass(itemKindIdClassFromAnnotation, defaultItemKindIdClass) + "." + field2;
            itemKindIdList.add((CallSite)((Object)itemKindId));
            this.fieldPropertyPaths = new String[]{this.propertyPath};
        }
        this.itemKindIds = itemKindIdList.toArray(new String[itemKindIdList.size()]);
        this.paramMap.put("itemKindIds", this.itemKindIds);
        if (this.getAnnotation().startsWith(CONDITIONAL_VALIDATOR_PREFIX)) {
            ConditionPattern conditionPtn = (ConditionPattern)((Object)this.paramMap.get("conditionPattern"));
            this.paramMap.put("conditionPattern", (Object)conditionPtn);
            String valuesOfConditionPropertyPathToValidate = null;
            if (conditionPtn == ConditionPattern.valueOfConditionPropertyPathIsEqualToValueOf || conditionPtn == ConditionPattern.valueOfConditionPropertyPathIsNotEqualToValueOf) {
                Object obj = ConstraintViolationBean.getFieldValue((String)this.paramMap.get("conditionValuePropertyPath"), this.getInstance());
                if (obj instanceof Object[]) {
                    List<String> strList = Arrays.asList(obj).stream().map(o -> o.toString()).toList();
                    valuesOfConditionPropertyPathToValidate = StringUtil.getCsvWithSpace(strList.toArray(new String[strList.size()]));
                } else {
                    valuesOfConditionPropertyPathToValidate = String.valueOf(obj);
                }
            } else if (conditionPtn == ConditionPattern.stringValueOfConditionPropertyPathIsEqualTo || conditionPtn == ConditionPattern.stringValueOfConditionPropertyPathIsNotEqualTo) {
                String[] strs = (String[])this.paramMap.get("conditionValueString");
                valuesOfConditionPropertyPathToValidate = StringUtil.getCsvWithSpace(strs);
            }
            String valueOfConditionValuePropertyPathForDisplay = (String)this.paramMap.get("valueOfConditionValuePropertyPathForDisplay");
            if (!valueOfConditionValuePropertyPathForDisplay.equals("")) {
                String[] strs = (String[])ConstraintViolationBean.getFieldValue(valueOfConditionValuePropertyPathForDisplay, this.getInstance());
                valuesOfConditionPropertyPathToValidate = StringUtil.getCsvWithSpace(strs);
            }
            this.paramMap.put("valuesOfConditionFieldToValidate", valuesOfConditionPropertyPathToValidate);
            boolean bl = this.getAnnotation().endsWith("ConditionalEmpty") && (Boolean)this.paramMap.get("notEmptyWhenConditionNotSatisfied") != false || this.getAnnotation().endsWith("ConditionalNotEmpty") && (Boolean)this.paramMap.get("emptyWhenConditionNotSatisfied") != false;
            this.paramMap.put("validatesWhenConditionNotSatisfied", bl);
        }
    }

    private String getFinalItemKindIdClass(Optional<String> itemKindIdClassFromAnnotation, String defaultItemKindIdClass) {
        String itemKindIdClass = itemKindIdClassFromAnnotation.orElse(defaultItemKindIdClass);
        return itemKindIdClass.split("\\$")[itemKindIdClass.split("\\$").length - 1];
    }

    public String getMessage() {
        return this.message;
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public String getValidatorClass() {
        return this.validatorClass;
    }

    public String getAnnotationDescriptionString() {
        return this.annotationDescriptionString;
    }

    public String getAnnotation() {
        return this.cv.getConstraintDescriptor().getAnnotation().annotationType().getCanonicalName();
    }

    public Map<String, Object> getAnnotationAttributes() {
        return this.cv.getConstraintDescriptor().getAttributes();
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public String getRootClassName() {
        return this.rootClassName;
    }

    public String getLeafClassName() {
        return this.cv.getLeafBean().getClass().getName();
    }

    public String getInvalidValue() {
        return this.cv.getInvalidValue() == null ? "null" : this.cv.getInvalidValue().toString();
    }

    @Nonnull
    public String getMessageId() {
        return this.getAnnotation();
    }

    public Object getInstance() {
        return this.cv.getLeafBean();
    }

    public String[] getItemKindIds() {
        return this.itemKindIds;
    }

    @Nonnull
    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }

    public String[] getFieldPropertyPaths() {
        return this.fieldPropertyPaths;
    }
}

