/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.logging;

import jakarta.annotation.Nullable;
import java.util.Locale;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.unchecked.UncheckedAppException;
import jp.ecuacion.lib.core.logging.internal.EclibLogger;
import jp.ecuacion.lib.core.util.ExceptionUtil;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import org.slf4j.event.Level;

public class DetailLogger
extends EclibLogger {
    public DetailLogger(@RequireNonnull Object object) {
        this(object.getClass());
        ObjectsUtil.requireNonNull(object);
    }

    public DetailLogger(@RequireNonnull Class<?> cls) {
        super(cls);
        ObjectsUtil.requireNonNull(cls);
    }

    public void trace(@RequireNonnull String message) {
        this.log(Level.TRACE, message);
    }

    public void debug(@RequireNonnull String message) {
        this.log(Level.DEBUG, message);
    }

    public void info(@RequireNonnull String message) {
        this.log(Level.INFO, message);
    }

    public void warn(@RequireNonnull String message) {
        this.log(Level.WARN, message);
    }

    public void error(@RequireNonnull String message) {
        this.log(Level.ERROR, message);
    }

    public void error(@RequireNonnull Throwable th) {
        ObjectsUtil.requireNonNull(th);
        this.log(Level.ERROR, "A system error has occurred: ", th);
    }

    public void logSystemError(@RequireNonnull Throwable throwable) {
        this.logSystemError(throwable, null);
    }

    public void logSystemError(@RequireNonnull Throwable throwable, @Nullable String additionalMessage) {
        ObjectsUtil.requireNonNull(throwable);
        if (throwable instanceof AppException || throwable instanceof UncheckedAppException) {
            StringBuilder sb = new StringBuilder();
            AppException ae = throwable instanceof UncheckedAppException ? (AppException)((UncheckedAppException)throwable).getCause() : (AppException)throwable;
            ExceptionUtil.getAppExceptionMessageList(ae, Locale.getDefault()).forEach(tmpMsg -> sb.append(tmpMsg + "\n"));
            additionalMessage = (String)additionalMessage + "\n" + sb.toString();
        }
        this.log(Level.ERROR, ExceptionUtil.getErrLogString(throwable, (String)additionalMessage, Locale.ENGLISH));
    }

    public void logExceptionAsDebugInfo(@RequireNonnull Throwable throwable) {
        ObjectsUtil.requireNonNull(throwable);
        this.internalLogger.debug("[ecuacion-lib] The following is only for reference. (No system error will occur)");
    }

    private void log(@RequireNonnull Level logLevel, @RequireNonnull String message, @RequireNonnull Throwable throwable) {
        ObjectsUtil.requireNonNull(message, logLevel, throwable);
        switch (logLevel) {
            case ERROR: {
                this.internalLogger.error(message, throwable);
                break;
            }
            case WARN: {
                this.internalLogger.warn(message, throwable);
                break;
            }
            case INFO: {
                this.internalLogger.info(message, throwable);
                break;
            }
            case DEBUG: {
                this.internalLogger.debug(message, throwable);
                break;
            }
            case TRACE: {
                this.internalLogger.trace(message, throwable);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf(logLevel));
            }
        }
    }
}

