/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util.internal;

import jakarta.annotation.Nonnull;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Optional;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import org.apache.commons.lang3.tuple.Pair;

public class ReflectionUtil {
    protected static <A extends Annotation> Optional<A> searchAnnotationPlacedAtClass(Object instance, Class<A> annotation) {
        Class<?> cls = instance.getClass();
        while (cls != Object.class) {
            A an = cls.getAnnotation(annotation);
            if (an != null) {
                return Optional.of(an);
            }
            cls = cls.getSuperclass();
        }
        return Optional.empty();
    }

    protected static Object getFieldValue(String fieldName, Object instance) {
        Pair<Field, Object> pair = ReflectionUtil.getField(fieldName, instance);
        Field field = (Field)pair.getLeft();
        Object instanceOfField = pair.getRight();
        field.setAccessible(true);
        try {
            return field.get(instanceOfField);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            ReflectionUtil.throwRuntimeException(ex, fieldName, "Field value");
            return null;
        }
    }

    @Nonnull
    protected static Pair<Field, Object> getField(String fieldName, Object instance) {
        Class<?> cls = instance.getClass();
        Exception ex = null;
        if (fieldName.contains(".")) {
            Object chileIns = ReflectionUtil.getFieldValue(fieldName.substring(0, fieldName.indexOf(".")), instance);
            return ReflectionUtil.getField(fieldName.substring(fieldName.indexOf(".") + 1), chileIns);
        }
        while (!cls.equals(Object.class)) {
            try {
                Field validationTargetField = cls.getDeclaredField(fieldName);
                return Pair.of((Object)validationTargetField, (Object)instance);
            }
            catch (Exception exception) {
                if (ex == null) {
                    ex = exception;
                }
                cls = cls.getSuperclass();
            }
        }
        ReflectionUtil.throwRuntimeException(ex, fieldName, "Field");
        return null;
    }

    private static void throwRuntimeException(Exception ex, String fieldName, String whatIsTriedToObtain) {
        throw new EclibRuntimeException(whatIsTriedToObtain + " cannot be obtained from the field name '" + fieldName + "'", ex);
    }
}

