/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FileUtil {
    private FileUtil() {
    }

    @Nonnull
    public static String getFileSavableName(@RequireNonnull String origName) {
        ObjectsUtil.requireNonNull(origName);
        String rtn = origName;
        if (origName.indexOf("\\") >= 0) {
            rtn = rtn.replaceAll("\\\\", "__yen__");
        }
        if (origName.indexOf("/") >= 0) {
            rtn = rtn.replaceAll("/", "__slash__");
        }
        if (origName.indexOf(":") >= 0) {
            rtn = rtn.replaceAll(":", "__colon__");
        }
        if (origName.indexOf("*") >= 0) {
            rtn = rtn.replaceAll("\\*", "__asterisk__");
        }
        if (origName.indexOf("?") >= 0) {
            rtn = rtn.replaceAll("\\?", "__question__");
        }
        if (origName.indexOf("\"") >= 0) {
            rtn = rtn.replaceAll("\"", "__dquotation__");
        }
        if (origName.indexOf("<") >= 0) {
            rtn = rtn.replaceAll("<", "__lessthan__");
        }
        if (origName.indexOf(">") >= 0) {
            rtn = rtn.replaceAll(">", "__morethan__");
        }
        if (origName.indexOf("|") >= 0) {
            rtn = rtn.replaceAll("\\|", "__pipe__");
        }
        return rtn;
    }

    @Nonnull
    private static String concatTwoFilePaths(@RequireNonnull String path1, @RequireNonnull String path2) {
        ObjectsUtil.requireNonNull(path1, path2, new Object[0]);
        if (path1.endsWith("/")) {
            path1 = path1.substring(0, path1.length() - 1);
        }
        if (path2.startsWith("/")) {
            path2 = path2.substring(1);
        }
        return path1 + "/" + path2;
    }

    @Nonnull
    public static String concatFilePaths(String ... paths) {
        String concatPath = "";
        for (String path : paths) {
            concatPath = concatPath.equals("") ? path : FileUtil.concatTwoFilePaths(concatPath, path);
        }
        return concatPath;
    }

    private static int getFirstPathSeparatorIndex(@RequireNonnull String path) {
        ObjectsUtil.requireNonNull(path);
        int firstSlashIndex = path.indexOf("/");
        int firstBackSlashIndex = path.indexOf("\\");
        if (firstSlashIndex == -1 && firstBackSlashIndex == -1) {
            return -1;
        }
        if (firstSlashIndex == -1) {
            return firstBackSlashIndex;
        }
        if (firstBackSlashIndex == -1) {
            return firstSlashIndex;
        }
        return firstSlashIndex < firstBackSlashIndex ? firstSlashIndex : firstBackSlashIndex;
    }

    @Nonnull
    public static String cleanPathStrWithSlash(@RequireNonnull String path) {
        ObjectsUtil.requireNonNull(path);
        Object rtnStr = null;
        rtnStr = path.replaceAll("\\\\", "/");
        rtnStr = ((String)rtnStr).replaceAll("//", "/");
        if (((String)rtnStr).endsWith("/.")) {
            rtnStr = ((String)rtnStr).substring(0, ((String)rtnStr).length() - 2);
        }
        if (((String)rtnStr).indexOf("/./") >= 0) {
            rtnStr = ((String)rtnStr).substring(0, ((String)rtnStr).indexOf("/./")) + ((String)rtnStr).substring(((String)rtnStr).indexOf("/./") + 2);
        }
        if (((String)rtnStr).endsWith("/")) {
            rtnStr = ((String)rtnStr).substring(0, ((String)rtnStr).length() - 1);
        }
        return rtnStr;
    }

    @Nonnull
    public static boolean containsWildCard(@RequireNonnull String path) {
        return path.contains("?") || path.contains("*");
    }

    @Nonnull
    public static List<String> getPathListFromPathWithWildcard(@RequireNonnull String path) throws BizLogicAppException {
        ArrayList<String> fullPathList = new ArrayList<String>();
        if ((path = FileUtil.cleanPathStrWithSlash(path)).endsWith("/") || path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        if (FileUtil.isRelativePath(path)) {
            path = FileUtil.changeRelPathToFullPath(path);
        }
        path = FileUtil.cleanPathStrWithSlash(path);
        FileUtil.getPathListFromPathWithWildcardRecursively(path, "", fullPathList);
        return fullPathList;
    }

    @Nonnull
    public static boolean isRelativePath(@RequireNonnull String path) throws BizLogicAppException {
        if (path == null || path.equals("")) {
            throw new BizLogicAppException("MSG_ERR_PATH_IS_NULL", new String[0]);
        }
        return !(System.getProperty("os.name").toUpperCase().contains("WINDOWS") ? path.length() >= 2 && path.substring(1, 2).equals(":") : path.length() >= 1 && path.substring(0, 1).equals("/"));
    }

    @Nonnull
    private static String changeRelPathToFullPath(@RequireNonnull String path) {
        String curPath = new File(".").getAbsolutePath();
        String fullPath = FileUtil.concatFilePaths(curPath, path);
        fullPath = fullPath.replaceAll("\\.\\\\", "").replaceAll("\\./", "");
        return fullPath;
    }

    private static void getPathListFromPathWithWildcardRecursively(@RequireNonnull String fullPath, @RequireNonnull String parentPath, @RequireNonnull List<String> rtnFullPathList) throws BizLogicAppException {
        ObjectsUtil.requireNonNull(fullPath, parentPath, rtnFullPathList);
        String myFileOrDirnameWithWildcard = null;
        boolean hasReachedFullPathDirDepth = false;
        if (parentPath.equals("")) {
            String myPathWithWildcard = fullPath.substring(0, FileUtil.getFirstPathSeparatorIndex(fullPath) + 1);
            if (myPathWithWildcard.contains("*") || myPathWithWildcard.contains("?")) {
                throw new BizLogicAppException("MSG_ERR_1ST_LEVEL_CANNOT_HAVE_WILDCARD", fullPath);
            }
            FileUtil.getPathListFromPathWithWildcardRecursively(fullPath, myPathWithWildcard, rtnFullPathList);
        } else {
            int numOfSeparatorOfParentPath = StringUtils.countMatches((CharSequence)parentPath, (CharSequence)"/");
            String fullPathMinusParentPath = fullPath.substring(StringUtils.ordinalIndexOf((CharSequence)fullPath, (CharSequence)"/", (int)numOfSeparatorOfParentPath) + 1);
            int ind = FileUtil.getFirstPathSeparatorIndex(fullPathMinusParentPath);
            if (ind >= 0) {
                myFileOrDirnameWithWildcard = fullPathMinusParentPath.substring(0, ind + 1);
            } else {
                myFileOrDirnameWithWildcard = fullPathMinusParentPath;
                hasReachedFullPathDirDepth = true;
            }
            if (myFileOrDirnameWithWildcard.contains("?") || myFileOrDirnameWithWildcard.contains("*")) {
                String myFileOrDirnameWithRegEx = myFileOrDirnameWithWildcard.replaceAll("\\.", "\\\\.");
                myFileOrDirnameWithRegEx = myFileOrDirnameWithRegEx.replaceAll("\\?", ".").replaceAll("\\*", ".*");
                Pattern pattern1 = Pattern.compile(parentPath + myFileOrDirnameWithRegEx);
                String[] arr = new File(parentPath).list();
                if (arr == null) {
                    throw new RuntimeException("arr cannot be null.");
                }
                for (String path : arr) {
                    Object myFullPath = parentPath + path;
                    Matcher matcher = pattern1.matcher((CharSequence)(myFullPath = FileUtil.cleanPathStrWithSlash((String)myFullPath)));
                    if (!matcher.matches()) continue;
                    if (hasReachedFullPathDirDepth) {
                        rtnFullPathList.add((String)myFullPath);
                        continue;
                    }
                    FileUtil.getPathListFromPathWithWildcardRecursively(fullPath, (String)myFullPath, rtnFullPathList);
                }
            } else {
                String myFullPath = parentPath + myFileOrDirnameWithWildcard;
                if (new File(myFullPath).exists()) {
                    if (hasReachedFullPathDirDepth) {
                        rtnFullPathList.add(myFullPath);
                    } else {
                        FileUtil.getPathListFromPathWithWildcardRecursively(fullPath, myFullPath, rtnFullPathList);
                    }
                }
            }
        }
    }

    @Nonnull
    public static String getParentDirPath(@RequireNonnull String origPath) {
        ObjectsUtil.requireNonNull(origPath);
        String path = FileUtil.cleanPathStrWithSlash(origPath);
        return path.substring(0, path.lastIndexOf("/"));
    }

    @Nonnull
    public static String getFileNameFromFilePath(@RequireNonnull String path) {
        ObjectsUtil.requireNonNull(path);
        return path.substring(FileUtil.getParentDirPath(path).length()).replace("\\", "").replace("/", "");
    }

    @Nonnull
    public static String getFileSizeInMb(@RequireNonnull Long fileSize) {
        ObjectsUtil.requireNonNull(fileSize);
        double d = fileSize.longValue();
        System.out.println(Math.round(d / 100000.0));
        return Double.valueOf((double)Math.round(d / 100000.0) / 10.0).toString();
    }

    @Nonnull
    public static String getFileSizeInMbWithUnit(@RequireNonnull Long fileSize) {
        return FileUtil.getFileSizeInMb(fileSize) + " MB";
    }

    @Nonnull
    public static Pair<FileChannel, FileLock> lock(@RequireNonnull File lockFile, @Nullable String version) throws IOException {
        String fileTimestamp;
        ObjectsUtil.requireNonNull(lockFile);
        FileLock lockedObject = null;
        FileChannel channel = FileChannel.open(lockFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        lockedObject = channel.tryLock();
        if (lockedObject == null) {
            throw new OverlappingFileLockException();
        }
        if (version != null && !version.equals(fileTimestamp = FileUtil.getLockFileVersion(lockFile))) {
            throw new OverlappingFileLockException();
        }
        return Pair.of((Object)channel, (Object)lockedObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocked(@RequireNonnull String path) throws IOException {
        ObjectsUtil.requireNonNull(path);
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundException("\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
        if (!file.canWrite()) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, true);
        }
        catch (Exception e) {
            return true;
        }
        FileChannel fc = null;
        FileLock lock = null;
        try {
            fc = fos.getChannel();
            lock = fc.tryLock();
            if (lock == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
                if (fc != null) {
                    fc.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void release(@RequireNonnull Pair<FileChannel, FileLock> channelAndLock) throws IOException {
        FileChannel channel = (FileChannel)channelAndLock.getLeft();
        FileLock lockedObject = (FileLock)channelAndLock.getRight();
        try {
            byte[] bytes = LocalDateTime.now().toString().getBytes();
            ByteBuffer src = ByteBuffer.allocate(bytes.length);
            src.put(bytes);
            src.position(0);
            channel.write(src);
            lockedObject.release();
        }
        catch (OverlappingFileLockException ex) {
            throw new OverlappingFileLockException();
        }
    }

    @Nonnull
    public static String getLockFileVersion(@RequireNonnull File lockFile) throws IOException {
        lockFile.getParentFile().mkdirs();
        if (!lockFile.exists()) {
            lockFile.createNewFile();
        }
        return Instant.ofEpochMilli(lockFile.lastModified()).atOffset(ZoneOffset.ofHours(0)).format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss.SSS"));
    }
}

