/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.lib.core.util.ObjectsUtil;

public class EnumUtil {
    private EnumUtil() {
    }

    @Nonnull
    public static <T> T getEnumFromCode(@RequireNonnull Class<T> enumClass, @RequireNonnull String code) {
        ObjectsUtil.requireNonNull(enumClass, code, new Object[0]);
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException();
        }
        for (EnumValueInfo enumValue : EnumUtil.getEnumInfo(enumClass).valueList) {
            if (!enumValue.getCode().equals(code)) continue;
            return enumValue.getInstance();
        }
        throw new EclibRuntimeException("Enum: " + enumClass.getSimpleName() + "doesn't have the code. (code : " + code + ")");
    }

    public static <T> boolean hasEnumFromCode(@RequireNonnull Class<T> enumClass, @RequireNonnull String code) {
        try {
            T anEnum = EnumUtil.getEnumFromCode(ObjectsUtil.requireNonNull(enumClass), ObjectsUtil.requireNonNull(code));
            return anEnum != null;
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    @Nonnull
    public static <T> List<String[]> getListForHtmlSelect(@RequireNonnull Class<T> enumClass, @Nullable Locale locale, @Nullable String optionsString) {
        optionsString = optionsString == null ? "" : optionsString;
        String[] options = optionsString.split(",");
        EnumClassInfo<T> enumInfo = EnumUtil.getEnumInfo(enumClass);
        HashMap<String, String> optionMap = new HashMap<String, String>();
        for (String option : options) {
            String optionValue;
            String optionKey = option.split("=")[0];
            String string = optionValue = option.split("=").length == 1 ? null : option.split("=")[1];
            if (!ListForHtmlSelectOptionEnum.getNameSet().contains(optionKey)) continue;
            optionMap.put(optionKey, optionValue);
        }
        ArrayList<String[]> rtnList = new ArrayList<String[]>();
        if (optionMap.keySet().size() > 1) {
            throw new RuntimeException("Multiple options cannot be set. (" + optionMap.keySet().toString() + ")");
        }
        if (optionMap.keySet().size() == 0) {
            enumInfo.getValueList().stream().forEach(value -> rtnList.add(new String[]{value.getCode(), value.getLabel()}));
            return rtnList;
        }
        String optionKey = (String)optionMap.keySet().stream().toList().get(0);
        String optionValue = (String)optionMap.get(optionKey);
        for (EnumValueInfo<T> value2 : enumInfo.getValueList()) {
            if (!(optionKey.equals("including") && Arrays.asList(optionValue.split("\\|")).contains(value2.getName()) || optionKey.equals("excluding") && !Arrays.asList(optionValue.split("\\|")).contains(value2.getName()) || optionKey.equals("firstCharOfCodeEqualTo") && Arrays.asList(optionValue.split("\\|")).contains(value2.getCode().substring(0, 1)) || optionKey.equals("firstCharOfCodeLessThanOrEqualTo") && value2.getCode().substring(0, 1).getBytes(StandardCharsets.US_ASCII)[0] <= optionValue.getBytes(StandardCharsets.US_ASCII)[0]) && (!optionKey.equals("firstCharOfCodeGreaterThanOrEqualTo") || value2.getCode().substring(0, 1).getBytes(StandardCharsets.US_ASCII)[0] < optionValue.getBytes(StandardCharsets.US_ASCII)[0])) continue;
            rtnList.add(new String[]{value2.getCode(), value2.getLabel()});
        }
        return rtnList;
    }

    @Nonnull
    public static <T> EnumClassInfo<T> getEnumInfo(@RequireNonnull Class<T> enumClass) {
        return EnumUtil.getEnumInfo(enumClass, null);
    }

    @Nonnull
    public static <T> EnumClassInfo<T> getEnumInfo(@RequireNonnull Class<T> enumClass, @Nullable Locale locale) {
        ObjectsUtil.requireNonNull(enumClass);
        locale = locale == null ? Locale.getDefault() : locale;
        ArrayList valueList = new ArrayList();
        String enumClassName = enumClass.getSimpleName();
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException();
        }
        for (T enumValue : enumClass.getEnumConstants()) {
            String name = enumValue.toString();
            try {
                Method codeMethod = enumClass.getMethod("getCode", null);
                String code = (String)codeMethod.invoke(enumValue, (Object[])null);
                Method displayNameMethod = enumClass.getMethod("getDisplayName", Locale.class);
                String displayName = (String)displayNameMethod.invoke(enumValue, locale);
                valueList.add(new EnumValueInfo<T>(name, code, displayName, enumValue, enumClassName));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return new EnumClassInfo(enumClass.getSimpleName(), valueList);
    }

    public static class EnumClassInfo<T> {
        private String enumClassName;
        private List<EnumValueInfo<T>> valueList;

        public EnumClassInfo(String enumClassName, List<EnumValueInfo<T>> valueList) {
            this.enumClassName = enumClassName;
            this.valueList = valueList;
        }

        public String getEnumClassName() {
            return this.enumClassName;
        }

        public List<EnumValueInfo<T>> getValueList() {
            return this.valueList;
        }
    }

    public static class EnumValueInfo<T> {
        private String name;
        private String code;
        private String displayName;
        private T instance;
        private String enumClassName;

        public EnumValueInfo(String name, String code, String label, T instance, String enumClassName) {
            this.name = name;
            this.code = code;
            this.displayName = label;
            this.instance = instance;
            this.enumClassName = enumClassName;
        }

        public String getName() {
            return this.name;
        }

        public String getCode() {
            return this.code;
        }

        public String getLabel() {
            return this.displayName;
        }

        public T getInstance() {
            return this.instance;
        }

        public String getEnumClassName() {
            return this.enumClassName;
        }
    }

    private static enum ListForHtmlSelectOptionEnum {
        including,
        excluding,
        firstCharOfCodeEqualTo,
        firstCharOfCodeLessThanOrEqualTo,
        firstCharOfCodeGreaterThanOrEqualTo;


        public static Set<String> getNameSet() {
            HashSet<String> rtnSet = new HashSet<String>();
            for (ListForHtmlSelectOptionEnum anEnum : ListForHtmlSelectOptionEnum.values()) {
                rtnSet.add(anEnum.name());
            }
            return rtnSet;
        }
    }
}

