/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.util.ObjectsUtil;

public class DateTimeApiUtil {
    private static final String REG_OF_DIFF = "\\+[0-9]{2}:[0-9]{2}";
    private static final String FM_OF_DIFF = "[xxx][xx][X]";
    private static final String REG_OF_DATE_DASHES = "[0-9]{4}-[0-9]{2}-[0-9]{2}";
    private static final String FM_OF_DATE_DASHES = "yyyy-MM-dd";
    private static final String REG_OF_DATE_SLASHES = "[0-9]{4}/[0-9]{2}/[0-9]{2}";
    private static final String FM_OF_DATE_SLASHES = "yyyy/MM/dd";
    private static final String REG_OF_SEP1_T = "T";
    private static final String FM_OF_SEP1_T = "'T'";
    private static final String REG_OF_SEP1_SP = " ";
    private static final String FM_OF_SEP1_SP = "' '";
    private static final String REG_OF_TIME = "[0-9]{2}:[0-9]{2}:[0-9]{2}(\\.[0-9]*)?";
    private static final String FM_OF_TIME = "HH:mm:ss[.SSSSSSSSS][.SSSSSS][.SSS]";
    private static final String USER_FRIENDLY_LOCAL_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String USER_FRIENDLY_OFFSET_FORMAT = "yyyy-MM-dd HH:mm:ss ZZZZZ";

    private DateTimeApiUtil() {
    }

    @Nonnull
    public static String getLocalDateTimeDisplayString(@RequireNonnull LocalDateTime localDateTime) {
        ObjectsUtil.requireNonNull(localDateTime);
        return localDateTime.format(DateTimeFormatter.ofPattern(USER_FRIENDLY_LOCAL_FORMAT));
    }

    @Nonnull
    public static String getLocalDateTimeDisplayString(@RequireNonnull OffsetDateTime dateTime, @Nullable ZoneId zoneId) {
        ObjectsUtil.requireNonNull(dateTime);
        zoneId = zoneId == null ? ZoneId.systemDefault() : zoneId;
        return dateTime.atZoneSameInstant(zoneId).toLocalDateTime().format(DateTimeFormatter.ofPattern(USER_FRIENDLY_LOCAL_FORMAT));
    }

    @Nonnull
    public static String getOffsetDateTimeDisplayString(@RequireNonnull OffsetDateTime offsetDateTime, @Nullable ZoneId zoneId) {
        ObjectsUtil.requireNonNull(offsetDateTime);
        zoneId = zoneId == null ? ZoneId.systemDefault() : zoneId;
        return offsetDateTime.atZoneSameInstant(zoneId).format(DateTimeFormatter.ofPattern(USER_FRIENDLY_OFFSET_FORMAT));
    }

    @Nonnull
    public static LocalDateTime getLocalDateTime(@RequireNonnull String dateTimeString) {
        FormatHolder obj = DateTimeApiUtil.getLocalDateTimePartFormat(dateTimeString);
        return LocalDateTime.parse(dateTimeString, DateTimeFormatter.ofPattern(obj.fmStr));
    }

    @Nonnull
    public static OffsetDateTime getOffsetDateTime(@RequireNonnull String dateTimeString) {
        FormatHolder obj = DateTimeApiUtil.getLocalDateTimePartFormat(dateTimeString);
        if (dateTimeString.matches("^" + obj.regStr + "\\+[0-9]{2}:[0-9]{2}.*")) {
            obj.appendStrings(REG_OF_DIFF, FM_OF_DIFF);
        } else if (dateTimeString.matches("^" + obj.regStr + " \\+[0-9]{2}:[0-9]{2}.*")) {
            obj.appendStrings(REG_OF_SEP1_SP, FM_OF_SEP1_SP);
            obj.appendStrings(REG_OF_DIFF, FM_OF_DIFF);
        } else {
            throw new RuntimeException("Date format incorrect. (date time string: " + dateTimeString + ")");
        }
        return OffsetDateTime.parse(dateTimeString, DateTimeFormatter.ofPattern(obj.fmStr));
    }

    @Nonnull
    private static FormatHolder getLocalDateTimePartFormat(@RequireNonnull String dateTimeString) {
        ObjectsUtil.requireNonNull(dateTimeString);
        FormatHolder obj = new FormatHolder();
        if (dateTimeString.matches("^[0-9]{4}-[0-9]{2}-[0-9]{2}.*")) {
            obj.appendStrings(REG_OF_DATE_DASHES, FM_OF_DATE_DASHES);
        } else if (dateTimeString.matches("^[0-9]{4}/[0-9]{2}/[0-9]{2}.*")) {
            obj.appendStrings(REG_OF_DATE_SLASHES, FM_OF_DATE_SLASHES);
        } else {
            throw new RuntimeException("Date format incorrect. (date time string: " + dateTimeString + ")");
        }
        if (dateTimeString.matches("^" + obj.regStr + "T.*")) {
            obj.appendStrings(REG_OF_SEP1_T, FM_OF_SEP1_T);
        } else if (dateTimeString.matches("^" + obj.regStr + " .*")) {
            obj.appendStrings(REG_OF_SEP1_SP, FM_OF_SEP1_SP);
        } else {
            throw new RuntimeException("Date format incorrect. (date time string: " + dateTimeString + ")");
        }
        if (!dateTimeString.matches("^" + obj.regStr + "[0-9]{2}:[0-9]{2}:[0-9]{2}(\\.[0-9]*)?.*")) {
            throw new RuntimeException("Date format incorrect. (date time string: " + dateTimeString + ")");
        }
        obj.appendStrings(REG_OF_TIME, FM_OF_TIME);
        return obj;
    }

    static class FormatHolder {
        public String regStr = "";
        public String fmStr = "";

        FormatHolder() {
        }

        public void appendStrings(String regStrAppender, String fmStrAppender) {
            this.regStr = this.regStr + regStrAppender;
            this.fmStr = this.fmStr + fmStrAppender;
        }
    }
}

