/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.ExceptionUtil;
import jp.ecuacion.lib.core.util.LogUtil;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.lib.core.util.internal.MailUtilEmail;
import jp.ecuacion.lib.core.util.internal.MailUtilEmailContent;
import jp.ecuacion.lib.core.util.internal.MailUtilEmailServer;
import jp.ecuacion.lib.core.util.internal.MailUtilEmailSettings;
import jp.ecuacion.lib.core.util.internal.MailUtilLogOutputStream;

public class MailUtil {
    private static DetailLogger dtlLog = new DetailLogger(MailUtil.class);
    private static final String APP_PREFIX = "jp.ecuacion.lib.core.mail.";

    private MailUtil() {
    }

    public static void sendErrorMail(@RequireNonnull Throwable throwable) {
        MailUtil.sendErrorMail(throwable, null);
    }

    public static void sendErrorMail(@RequireNonnull Throwable throwable, @Nullable String additionalMessage) {
        ObjectsUtil.requireNonNull(throwable);
        List<String> errorMailAddressList = Arrays.asList(PropertyFileUtil.getApplication("jp.ecuacion.lib.core.mail.address-csv-on-system-error").split(","));
        if (errorMailAddressList == null || errorMailAddressList.size() == 0) {
            return;
        }
        String mailTitle = PropertyFileUtil.getApplication("title-prefix") + "A system error has occurred.";
        try {
            MailUtil.sendMailCommon(errorMailAddressList, null, mailTitle, MailUtil.getErrorMailContent(throwable, additionalMessage), false);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Nonnull
    private static String getErrorMailContent(@RequireNonnull Throwable e, @Nullable String additionalMessage) {
        StringBuffer msgSb = new StringBuffer();
        msgSb.append(ExceptionUtil.getErrLogString(e, additionalMessage, Locale.getDefault()) + "\n");
        String rtn = msgSb.toString();
        return rtn;
    }

    @Nonnull
    public static void sendWarnMail(@Nullable String content, @RequireNonnull List<String> mailToList) {
        ObjectsUtil.requireNonNull(mailToList);
        ObjectsUtil.requireSizeNonZero(mailToList);
        String envSpecStr = PropertyFileUtil.getApplication("jp.ecuacion.lib.core.mail.title-prefix");
        try {
            MailUtil.sendMailCommon(mailToList, null, envSpecStr + "Warn Message", content, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendMail(@Nullable List<String> mailToList, @Nullable List<String> mailCcList, @RequireNonnull String title, @Nullable String content) throws Exception {
        MailUtil.sendMailCommon(mailToList, mailCcList, title, content, true);
    }

    private static void sendMailCommon(@Nullable List<String> mailToList, @Nullable List<String> mailCcList, @RequireNonnull String title, @Nullable String content, boolean throwsException) throws Exception {
        ObjectsUtil.requireNonNull(title);
        if (!(mailToList != null && mailToList.size() != 0 || mailCcList != null && mailCcList.size() != 0)) {
            throw new EclibRuntimeException("Either mailToList or mailCcList need to have at least one element.");
        }
        String mailFrom = PropertyFileUtil.getApplication("jp.ecuacion.lib.core.mail.smtp.sender");
        String pass = PropertyFileUtil.getApplication("jp.ecuacion.lib.core.mail.smtp.password");
        MailUtilEmailServer serverInfo = new MailUtilEmailServer(PropertyFileUtil.getApplication("jp.ecuacion.lib.core.mail.smtp.server"), PropertyFileUtil.getApplication("jp.ecuacion.lib.core.mail.smtp.port"), PropertyFileUtil.hasApplication("jp.ecuacion.lib.core.mail.smtp.ssl-enabled") ? Boolean.parseBoolean(PropertyFileUtil.getApplication("jp.ecuacion.lib.core.mail.smtp.ssl-enabled")) : false, Boolean.parseBoolean(PropertyFileUtil.getApplication("jp.ecuacion.lib.core.mail.smtp.authentication")), Boolean.parseBoolean(PropertyFileUtil.getApplication("jp.ecuacion.lib.core.mail.smtp.checks-certificate")), PropertyFileUtil.hasApplication("jp.ecuacion.lib.core.mail.smtp.bounce-address") ? PropertyFileUtil.getApplication("jp.ecuacion.lib.core.mail.smtp.bounce-address") : null);
        boolean debug = PropertyFileUtil.hasApplication("jp.ecuacion.lib.core.mail.debug") ? Boolean.valueOf(PropertyFileUtil.getApplication("jp.ecuacion.lib.core.mail.debug")) : false;
        MailUtil.sendMailInternal(mailFrom, pass, mailToList, mailCcList, title, content, new MailUtilEmail(serverInfo, new MailUtilEmailContent(mailFrom), new MailUtilEmailSettings(debug)), throwsException);
    }

    private static void sendMailInternal(String mailFrom, String pass, @Nonnull List<String> mailToList, List<String> mailCcList, String title, String content, MailUtilEmail emailInfo, boolean throwsException) throws Exception {
        try {
            if (!(mailToList != null && mailToList.size() != 0 || mailCcList != null && mailCcList.size() != 0)) {
                System.out.println("mail:no TO or CC specified.");
                return;
            }
            Objects.requireNonNull(mailToList);
            Session session = null;
            session = emailInfo.getServerInfo().isNeedsAuthentication() ? Session.getInstance((Properties)emailInfo.getProperties(), (Authenticator)new MyAuth(mailFrom, pass)) : Session.getDefaultInstance((Properties)emailInfo.getProperties());
            session.setDebug(emailInfo.getSettingInfo().getOutputsDebugLog());
            session.setDebugOut(new PrintStream((OutputStream)new MailUtilLogOutputStream(), true, "UTF-8"));
            InternetAddress[] addressTo = new InternetAddress[mailToList.size()];
            for (int i = 0; i < mailToList.size(); ++i) {
                addressTo[i] = new InternetAddress(mailToList.get(i));
            }
            MimeMessage msg = null;
            msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(mailFrom));
            msg.setSentDate(new Date());
            msg.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
            msg.setSubject(title, "UTF-8");
            msg.setText(content, "UTF-8");
            for (int i = 0; i < 3; ++i) {
                try {
                    MailUtil.sendMailToSmtp(emailInfo.getServerInfo().isNeedsAuthentication(), (Message)msg, emailInfo.getServerInfo().getSmtpServer(), mailFrom, pass, session, addressTo);
                    break;
                }
                catch (Exception e) {
                    if (i >= 2) {
                        dtlLog.info("\u30e1\u30fc\u30eb\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30ea\u30c8\u30e9\u30a4\u3057\u3066\u3082\u30a8\u30e9\u30fc\u767a\u751f\u7d99\u7d9a\u306e\u305f\u3081\u7d42\u4e86\u3057\u307e\u3059\u3002");
                        throw e;
                    }
                    dtlLog.info("\u30e1\u30fc\u30eb\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30ea\u30c8\u30e9\u30a4\u3057\u307e\u3059\u3002");
                    continue;
                }
            }
            dtlLog.trace("Mail successfully sent" + emailInfo.getDebugLogMessage());
        }
        catch (Throwable th1) {
            if (throwsException) {
                LogUtil.logSystemError(dtlLog, th1);
                throw th1;
            }
            try {
                LogUtil.logSystemError(dtlLog, th1);
            }
            catch (Throwable th2) {
                try {
                    th2.printStackTrace();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static void sendMailToSmtp(boolean doesNeedAuthentication, Message msg, String smtpSrv, String mailFrom, String pass, Session session, InternetAddress[] addressTo) throws NoSuchProviderException, MessagingException {
        if (doesNeedAuthentication) {
            Transport tp = session.getTransport("smtp");
            tp.connect(smtpSrv, mailFrom, pass);
            tp.sendMessage(msg, (Address[])addressTo);
        } else {
            Transport.send((Message)msg);
        }
    }

    static class MyAuth
    extends Authenticator {
        private String mailFrom;
        private String pass;

        public MyAuth(String mailFrom, String pass) {
            this.mailFrom = mailFrom;
            this.pass = pass;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.mailFrom, this.pass);
        }
    }
}

