/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import jp.ecuacion.lib.core.annotation.RequireElementNonempty;
import jp.ecuacion.lib.core.annotation.RequireNonempty;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.annotation.RequireSizeNonzero;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.jakartavalidation.validator.PatternWithDescription;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.ValidationUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class EmbeddedParameterUtil {
    private static final String MSG_PREFIX = "jp.ecuacion.lib.core.util.EmbeddedParameterUtil.";

    private EmbeddedParameterUtil() {
    }

    private static int getFirstFoundIndexOfSymbol(String string, String symbol) {
        int indexOfSymbol;
        int ordinal = 1;
        while (true) {
            indexOfSymbol = StringUtils.ordinalIndexOf((CharSequence)string, (CharSequence)symbol, (int)ordinal);
            int indexOfSymbolWithEscape = StringUtils.ordinalIndexOf((CharSequence)string, (CharSequence)("\\" + symbol), (int)ordinal);
            if (indexOfSymbol <= 0 || indexOfSymbolWithEscape != indexOfSymbol - 1) break;
            ++ordinal;
        }
        return indexOfSymbol;
    }

    @Nullable
    static String getFirstFoundEmbeddedParameter(@RequireNonnull String string, @RequireNonempty String startSymbol, @RequireNonempty String endSymbol, @Nullable Options options) throws StringFormatIncorrectException, MultipleAppException {
        ObjectsUtil.requireNonNull(string);
        ObjectsUtil.requireNonEmpty(startSymbol, endSymbol, new String[0]);
        int startIndex = EmbeddedParameterUtil.getFirstFoundIndexOfSymbol(string, startSymbol);
        int endIndex = EmbeddedParameterUtil.getFirstFoundIndexOfSymbol(string, endSymbol);
        if (startIndex < 0 && endIndex < 0) {
            return null;
        }
        if (startIndex < 0 && endIndex >= 0 || startIndex > endIndex) {
            if (options == null || !options.ignoresEmergenceOfEndSymbolOnly) {
                throw new StringFormatIncorrectException(string, startSymbol, endSymbol);
            }
            return EmbeddedParameterUtil.getFirstFoundEmbeddedParameter(string.substring(EmbeddedParameterUtil.getFirstFoundIndexOfSymbol(string, endSymbol) + endSymbol.length()), startSymbol, endSymbol, options);
        }
        String var = string.substring(startIndex + startSymbol.length(), endIndex - 1 + endSymbol.length());
        ValidationUtil.validateThenThrow(new ValidationBean(var));
        return var;
    }

    @Nullable
    static Pair<String, String> getFirstFoundEmbeddedParameter(@RequireNonnull String string, @RequireNonnull @RequireSizeNonzero @RequireElementNonempty String[] startSymbols, @RequireNonempty String endSymbol, @Nullable Options options) throws MultipleAppException, StringFormatIncorrectException {
        ObjectsUtil.requireSizeNonZero(ObjectsUtil.requireNonNull(startSymbols));
        ArrayList<StringFormatIncorrectException> exList = new ArrayList<StringFormatIncorrectException>();
        HashMap<Integer, String> firstFoundParamNameMap = new HashMap<Integer, String>();
        for (String startSymbol : startSymbols) {
            try {
                String param = EmbeddedParameterUtil.getFirstFoundEmbeddedParameter(string, startSymbol, endSymbol, options);
                if (param == null) continue;
                int i = string.indexOf(startSymbol + param + endSymbol);
                firstFoundParamNameMap.put(i, startSymbol);
            }
            catch (StringFormatIncorrectException ex) {
                exList.add(ex);
            }
        }
        List firstFoundParamNameList = firstFoundParamNameMap.keySet().stream().sorted().toList();
        if (firstFoundParamNameList.size() == 0) {
            if (exList.size() == 0) {
                return null;
            }
            throw new MultipleAppException(exList);
        }
        String firstFoundStartSymbol = (String)firstFoundParamNameMap.get(firstFoundParamNameList.get(0));
        return Pair.of((Object)((String)firstFoundParamNameMap.get(firstFoundParamNameList.get(0))), (Object)EmbeddedParameterUtil.getFirstFoundEmbeddedParameter(string, firstFoundStartSymbol, endSymbol, options));
    }

    @Nonnull
    public static List<Pair<String, String>> getPartList(@RequireNonnull String string, @RequireNonnull @RequireSizeNonzero @RequireElementNonempty String[] startSymbols, @RequireNonempty String endSymbol, @Nullable Options options) throws StringFormatIncorrectException, MultipleAppException {
        Pair<String, String> param = null;
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        String part = string;
        while (true) {
            String firstFoundParamName;
            if ((param = EmbeddedParameterUtil.getFirstFoundEmbeddedParameter(part, startSymbols, endSymbol, options)) == null) {
                if (part.length() > 0) {
                    list.add((Pair<String, String>)Pair.of(null, (Object)part));
                }
                return list;
            }
            String firstFoundStartSymbol = (String)param.getLeft();
            String parameterWithSymbols = firstFoundStartSymbol + (firstFoundParamName = (String)param.getRight()) + endSymbol;
            if (part.indexOf(parameterWithSymbols) > 0) {
                list.add((Pair<String, String>)Pair.of(null, (Object)part.substring(0, part.indexOf(parameterWithSymbols))));
            }
            list.add((Pair<String, String>)Pair.of((Object)firstFoundStartSymbol, (Object)firstFoundParamName));
            part = part.substring(part.indexOf(parameterWithSymbols) + parameterWithSymbols.length());
        }
    }

    @Nonnull
    public static List<Pair<String, String>> getPartList(@RequireNonnull String string, @RequireNonnull @RequireSizeNonzero @RequireElementNonempty String[] startSymbols, @RequireNonempty String endSymbol) throws AppException {
        return EmbeddedParameterUtil.getPartList(string, startSymbols, endSymbol, null);
    }

    private static Function<String, String> getValueGetterFromKey(Map<String, String> parameterMap) {
        return key -> (String)parameterMap.get(key);
    }

    public static String getParameterReplacedString(@RequireNonnull String string, @RequireNonempty String startSymbol, @RequireNonempty String endSymbol, @RequireNonnull Function<String, String> valueGetterFromKey, @Nullable Options options) throws StringFormatIncorrectException, MultipleAppException, ParameterNotFoundException {
        ObjectsUtil.requireNonNull(valueGetterFromKey);
        List<Pair<String, String>> list = EmbeddedParameterUtil.getPartList(string, new String[]{startSymbol}, endSymbol, options);
        StringBuilder sb = new StringBuilder();
        for (Pair<String, String> pair : list) {
            if (pair.getLeft() == null) {
                sb.append((String)pair.getRight());
                continue;
            }
            String value = valueGetterFromKey.apply((String)pair.getRight());
            if (value == null) {
                throw new ParameterNotFoundException((String)pair.getRight());
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static String getParameterReplacedString(@RequireNonnull String string, @RequireNonempty String startSymbol, @RequireNonempty String endSymbol, @RequireNonnull Function<String, String> valueGetterFromKey) throws StringFormatIncorrectException, MultipleAppException, ParameterNotFoundException {
        return EmbeddedParameterUtil.getParameterReplacedString(string, startSymbol, endSymbol, valueGetterFromKey, null);
    }

    public static String getParameterReplacedString(@RequireNonnull String string, @RequireNonempty String startSymbol, @RequireNonempty String endSymbol, @RequireNonnull Map<String, String> parameterMap, @Nullable Options options) throws StringFormatIncorrectException, MultipleAppException, ParameterNotFoundException {
        ObjectsUtil.requireNonNull(parameterMap);
        return EmbeddedParameterUtil.getParameterReplacedString(string, startSymbol, endSymbol, EmbeddedParameterUtil.getValueGetterFromKey(parameterMap), options);
    }

    public static String getParameterReplacedString(@RequireNonnull String string, @RequireNonempty String startSymbol, @RequireNonempty String endSymbol, @RequireNonnull Map<String, String> parameterMap) throws StringFormatIncorrectException, MultipleAppException, ParameterNotFoundException {
        return EmbeddedParameterUtil.getParameterReplacedString(string, startSymbol, endSymbol, parameterMap, null);
    }

    public static class Options {
        boolean ignoresEmergenceOfEndSymbolOnly = false;

        public Options setIgnoresEmergenceOfEndSymbolOnly(boolean ignoresEmergenceOfEndSymbolOnly) {
            this.ignoresEmergenceOfEndSymbolOnly = ignoresEmergenceOfEndSymbolOnly;
            return this;
        }
    }

    public static class StringFormatIncorrectException
    extends BizLogicAppException {
        private static final long serialVersionUID = 1L;

        public StringFormatIncorrectException(String string, String startSymbol, String endSymbol) {
            super("jp.ecuacion.lib.core.util.EmbeddedParameterUtil.variableFormatIncorrect.message", string, startSymbol, endSymbol);
        }
    }

    private static class ValidationBean {
        @PatternWithDescription(regexp="^[a-zA-Z0-9_\\-\\.]*$", descriptionId="embeddedParameter")
        private @PatternWithDescription(regexp="^[a-zA-Z0-9_\\-\\.]*$", descriptionId="embeddedParameter") String value;

        public ValidationBean(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class ParameterNotFoundException
    extends BizLogicAppException {
        private static final long serialVersionUID = 1L;

        public ParameterNotFoundException(String key) {
            super("jp.ecuacion.lib.core.util.EmbeddedParameterUtil.paramNotFoundInMap.message", key);
        }
    }
}

