/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.exception.checked;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppExceptionItemIds;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;

public class BizLogicAppException
extends SingleAppException {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private String messageId;
    @Nonnull
    private PropertyFileUtil.Arg[] messageArgs;
    @Nullable
    private AppExceptionItemIds itemIds;

    public BizLogicAppException(@Nonnull String messageId, String ... messageArgs) {
        this((AppExceptionItemIds)null, messageId, messageArgs);
    }

    public BizLogicAppException(@Nullable AppExceptionItemIds itemIds, @Nonnull String messageId, String ... messageArgs) {
        this(itemIds, ObjectsUtil.requireNonNull(messageId), Arrays.asList(ObjectsUtil.requireNonNull(messageArgs)).stream().map(arg -> PropertyFileUtil.Arg.string(arg)).toList().toArray(new PropertyFileUtil.Arg[messageArgs.length]));
    }

    public BizLogicAppException(@RequireNonnull String messageId, @RequireNonnull PropertyFileUtil.Arg[] messageArgs) {
        this(null, messageId, messageArgs);
    }

    public BizLogicAppException(@Nullable AppExceptionItemIds itemIds, @RequireNonnull String messageId, @RequireNonnull PropertyFileUtil.Arg[] messageArgs) {
        this.itemIds = itemIds;
        this.messageId = ObjectsUtil.requireNonNull(messageId);
        this.messageArgs = messageArgs;
    }

    @Override
    public String getMessage() {
        return PropertyFileUtil.getMessage(this.messageId, this.messageArgs);
    }

    @Nullable
    public AppExceptionItemIds getItemIds() {
        return this.itemIds;
    }

    @Nonnull
    public String getMessageId() {
        return this.messageId;
    }

    @Nonnull
    public PropertyFileUtil.Arg[] getMessageArgs() {
        return this.messageArgs == null ? new PropertyFileUtil.Arg[]{} : this.messageArgs;
    }

    public BizLogicAppException cause(Throwable th) {
        super.initCause(th);
        return this;
    }
}

