/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import java.util.ArrayList;
import java.util.Map;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.jakartavalidation.validator.PatternWithDescription;
import jp.ecuacion.lib.core.util.ValidationUtil;
import org.apache.commons.lang3.StringUtils;

public class EmbeddedParameterUtil {
    private static final String MSG_PREFIX = "jp.ecuacion.lib.core.util.EmbeddedParameterUtil.";

    private EmbeddedParameterUtil() {
    }

    static String getFirstFoundEmbeddedParameter(String string, String startSymbol, String endSymbol) throws AppException {
        if (startSymbol.length() == 0 || endSymbol.length() == 0) {
            throw new BizLogicAppException("jp.ecuacion.lib.core.util.EmbeddedParameterUtil.symbolLengthZero.message", startSymbol, endSymbol);
        }
        int startIndex = EmbeddedParameterUtil.getIndexOfSymbol(string, startSymbol);
        int endIndex = EmbeddedParameterUtil.getIndexOfSymbol(string, endSymbol);
        if (startIndex < 0 && endIndex < 0) {
            return null;
        }
        if (startIndex < 0 && endIndex >= 0 || startIndex > endIndex) {
            throw new BizLogicAppException("jp.ecuacion.lib.core.util.EmbeddedParameterUtil.variableFormatIncorrect.message", string, startSymbol, endSymbol);
        }
        String var = string.substring(startIndex + startSymbol.length(), endIndex - 1 + endSymbol.length());
        ValidationUtil.validateThenThrow(new ValidationBean(var));
        return var;
    }

    private static int getIndexOfSymbol(String string, String symbol) {
        int indexOfSymbol;
        int ordinal = 1;
        while (true) {
            indexOfSymbol = StringUtils.ordinalIndexOf((CharSequence)string, (CharSequence)symbol, (int)ordinal);
            int indexOfSymbolWithEscape = StringUtils.ordinalIndexOf((CharSequence)string, (CharSequence)("\\" + symbol), (int)ordinal);
            if (indexOfSymbol <= 0 || indexOfSymbolWithEscape != indexOfSymbol - 1) break;
            ++ordinal;
        }
        return indexOfSymbol;
    }

    public static String getParameterReplacedString(String string, String startSymbol, String endSymbol, Map<String, String> map) throws AppException {
        String param = null;
        ArrayList<Part> list = new ArrayList<Part>();
        String str = string;
        while (true) {
            if ((param = EmbeddedParameterUtil.getFirstFoundEmbeddedParameter(str, startSymbol, endSymbol)) == null) {
                if (str.length() <= 0) break;
                list.add(new Part(false, str));
                break;
            }
            if (!map.containsKey(param)) {
                throw new BizLogicAppException("jp.ecuacion.lib.core.util.EmbeddedParameterUtil.paramNotFoundInMap.message", param);
            }
            String parameterWithSymbols = startSymbol + param + endSymbol;
            if (str.indexOf(parameterWithSymbols) > 0) {
                list.add(new Part(false, str.substring(0, str.indexOf(parameterWithSymbols))));
            }
            list.add(new Part(true, param));
            str = str.substring(str.indexOf(parameterWithSymbols) + parameterWithSymbols.length());
        }
        StringBuilder sb = new StringBuilder();
        for (Part part : list) {
            String partStr = part.isParameter() ? map.get(part.getValue()) : part.getValue();
            sb.append(partStr);
        }
        return sb.toString();
    }

    private static class ValidationBean {
        @PatternWithDescription(regexp="^[a-zA-Z0-9_\\-\\.]*$", descriptionId="embeddedParameter")
        private @PatternWithDescription(regexp="^[a-zA-Z0-9_\\-\\.]*$", descriptionId="embeddedParameter") String value;

        public ValidationBean(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class Part {
        private boolean isParameter;
        private String value;

        public Part(boolean isParameter, String value) {
            this.isParameter = isParameter;
            this.value = value;
        }

        public boolean isParameter() {
            return this.isParameter;
        }

        public String getValue() {
            return this.value;
        }
    }
}

