/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.jakartavalidation.validator.internal;

import jakarta.validation.ConstraintValidatorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.lib.core.jakartavalidation.util.internal.PrivateFieldReader;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class ConditionalValidator
extends PrivateFieldReader {
    private String[] field;
    private String conditionField;
    private String[] conditionValue;
    private boolean conditionValueIsEmpty;
    private boolean conditionValueIsNotEmpty;
    private String fieldHoldingConditionValue;
    private boolean validatesWhenConditionNotSatisfied;
    public static final String VALIDATION_TARGET_FIELD = "validationTargetField";
    public static final String CONDITION_FIELD = "conditionField";
    public static final String CONDITION_VALUE = "conditionValue";
    public static final String CONDITION_VALUE_IS_EMPTY = "conditionValueIsEmpty";
    public static final String CONDITION_VALUE_IS_NOT_EMPTY = "conditionValueIsNotEmpty";
    public static final String FIELD_HOLDING_CONDITION_VALUE = "fieldHoldingConditionValue";
    public static final String CONDITION_VALUE_KIND = "conditionValueKind";
    public static final String VALUE_OF_CONDITION_FIELD_TO_VALIDATE = "valuesOfConditionFieldToValidate";
    public static final String VALIDATES_WHEN_CONDITION_NOT_SATISFIED = "validatesWhenConditionNotSatisfied";

    public void initialize(String[] field, String conditionField, String[] conditionValue, boolean conditionValueIsEmpty, boolean conditionValueIsNotEmpty, String fieldHoldingConditionValue, boolean validatesWhenConditionNotSatisfied) {
        this.field = field;
        this.conditionField = conditionField;
        this.conditionValue = conditionValue;
        this.conditionValueIsEmpty = conditionValueIsEmpty;
        this.conditionValueIsNotEmpty = conditionValueIsNotEmpty;
        this.fieldHoldingConditionValue = fieldHoldingConditionValue;
        this.validatesWhenConditionNotSatisfied = validatesWhenConditionNotSatisfied;
    }

    protected abstract boolean isValid(Object var1);

    public boolean isValid(Object instance, ConstraintValidatorContext context) {
        boolean satisfiesCondition = this.getSatisfiesCondition(instance);
        List<Object> valueOfFieldList = Arrays.asList(this.field).stream().map(f -> ConditionalValidator.getFieldValue(f, instance, VALIDATION_TARGET_FIELD)).toList();
        for (Object valueOfField : valueOfFieldList) {
            boolean result = this.isValidForSingleValueOfField(valueOfField, satisfiesCondition);
            if (result) continue;
            return false;
        }
        return true;
    }

    private boolean isValidForSingleValueOfField(Object valueOfField, boolean satisfiesCondition) {
        if (satisfiesCondition) {
            return this.isValid(valueOfField);
        }
        if (this.validatesWhenConditionNotSatisfied) {
            return this.isValidWhenConditionNotSatisfied(valueOfField);
        }
        return true;
    }

    boolean getSatisfiesCondition(Object instance) {
        Object valueOfConditionField = ConditionalValidator.getFieldValue(this.conditionField, instance, CONDITION_FIELD);
        if (this.conditionValueIsEmpty) {
            this.conditionValueIsNotEmptyMustBeFalse("conditionValueIsEmpty = true");
            this.fieldHoldingConditionalValueMustBeNull("conditionValueIsEmpty = true");
            this.conditionValueMustBeNull("conditionValueIsEmpty = true");
            if (valueOfConditionField == null || valueOfConditionField instanceof String && StringUtils.isEmpty((CharSequence)((String)valueOfConditionField))) {
                return true;
            }
        } else if (this.conditionValueIsNotEmpty) {
            this.fieldHoldingConditionalValueMustBeNull("conditionValueIsNotEmpty = true");
            this.conditionValueMustBeNull("conditionValueIsNotEmpty = true");
            boolean instanceOfString = valueOfConditionField instanceof String;
            if (!instanceOfString && valueOfConditionField != null || instanceOfString && !StringUtils.isEmpty((CharSequence)((String)valueOfConditionField))) {
                return true;
            }
        } else if (!this.fieldHoldingConditionValue.equals("[null]")) {
            this.conditionValueMustBeNull(FIELD_HOLDING_CONDITION_VALUE);
            Object valueOfFieldHoldingConditionValue = ConditionalValidator.getFieldValue(this.fieldHoldingConditionValue, instance, FIELD_HOLDING_CONDITION_VALUE);
            ArrayList<Object> valueOfFieldHoldingConditionValueList = new ArrayList<Object>();
            if (valueOfFieldHoldingConditionValue instanceof Object[]) {
                for (Object val : (Object[])valueOfFieldHoldingConditionValue) {
                    if (val == null) {
                        val = "[null]";
                    }
                    valueOfFieldHoldingConditionValueList.add(val);
                }
            }
            if (valueOfConditionField == null) {
                return valueOfFieldHoldingConditionValue == null || valueOfFieldHoldingConditionValue.equals("[null]") || valueOfFieldHoldingConditionValue instanceof Object[] && valueOfFieldHoldingConditionValueList.contains("[null]");
            }
            ObjectsUtil.requireNonNull(valueOfConditionField);
            if (valueOfFieldHoldingConditionValue == null) {
                return false;
            }
            ObjectsUtil.requireNonNull(valueOfFieldHoldingConditionValue);
            if (valueOfFieldHoldingConditionValue instanceof Object[]) {
                for (Object singleValue : (Object[])valueOfFieldHoldingConditionValue) {
                    if (singleValue == null) continue;
                    if (!valueOfConditionField.getClass().equals(singleValue.getClass())) {
                        throw new EclibRuntimeException("DataType Differs: " + String.valueOf(valueOfConditionField.getClass()) + " and " + String.valueOf(valueOfFieldHoldingConditionValue.getClass()));
                    }
                    if (!valueOfConditionField.equals(singleValue)) continue;
                    return true;
                }
            } else {
                if (!valueOfConditionField.getClass().equals(valueOfFieldHoldingConditionValue.getClass())) {
                    throw new EclibRuntimeException("DataType Differs: " + String.valueOf(valueOfConditionField.getClass()) + " and " + String.valueOf(valueOfFieldHoldingConditionValue.getClass()));
                }
                if (valueOfConditionField.equals(valueOfFieldHoldingConditionValue)) {
                    return true;
                }
            }
        } else {
            if (valueOfConditionField == null) {
                valueOfConditionField = "[null]";
            }
            if (!(valueOfConditionField instanceof String)) {
                throw new EclibRuntimeException("When 'conditionValue' is not null, 'validationConditionField' must be String.");
            }
            if (Arrays.asList(this.conditionValue).contains(valueOfConditionField)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidWhenConditionNotSatisfied(Object valueOfField) {
        return true;
    }

    private void conditionValueIsNotEmptyMustBeFalse(String prerequisite) {
        if (this.conditionValueIsNotEmpty) {
            throw new EclibRuntimeException("When you set '" + prerequisite + "', you cannot set 'conditionValueIsNotEmpty = true'.");
        }
    }

    private void fieldHoldingConditionalValueMustBeNull(String prerequisite) {
        if (!this.fieldHoldingConditionValue.equals("[null]")) {
            throw new EclibRuntimeException("When you set '" + prerequisite + "', you cannot set 'fieldHoldingConditionValue'.");
        }
    }

    private void conditionValueMustBeNull(String prerequisite) {
        if (!Arrays.asList(this.conditionValue).contains("[null]")) {
            throw new EclibRuntimeException("When you set '" + prerequisite + "', you cannot set 'conditionValue = true'.");
        }
    }
}

