/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.exception.checked.ValidationAppException;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;

public class ValidationUtil {
    private ValidationUtil() {
    }

    @Nonnull
    public static <T> Set<ConstraintViolation<T>> validate(@RequireNonnull T object) {
        ObjectsUtil.paramRequireNonNull(object);
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        return validator.validate(object, new Class[0]);
    }

    public static <T> void validateThenThrow(@RequireNonnull T object) throws MultipleAppException {
        ValidationUtil.validateThenThrow(object, null, null, null);
    }

    public static <T> void validateThenThrow(@RequireNonnull T object, @Nullable Boolean addsItemNameToMessage, @Nullable PropertyFileUtil.Arg messagePrefix, @Nullable PropertyFileUtil.Arg messagePostfix) throws MultipleAppException {
        Optional<MultipleAppException> exOpt = ValidationUtil.validateThenReturn(object);
        if (exOpt.isPresent()) {
            throw exOpt.get();
        }
    }

    @Nonnull
    public static <T> Optional<MultipleAppException> validateThenReturn(@RequireNonnull T object) {
        return ValidationUtil.validateThenReturn(object, null, null, null);
    }

    @Nonnull
    public static <T> Optional<MultipleAppException> validateThenReturn(@RequireNonnull T object, @Nullable Boolean addsItemNameToMessage, @Nullable PropertyFileUtil.Arg messagePrefix, @Nullable PropertyFileUtil.Arg messagePostfix) {
        Set<ConstraintViolation<T>> set = ValidationUtil.validate(object);
        MultipleAppException exList = null;
        if (set != null && set.size() > 0) {
            ArrayList<ValidationAppException> list = new ArrayList<ValidationAppException>();
            for (ConstraintViolation<T> v : set) {
                ValidationAppException bvex = new ValidationAppException(v).setMessageWithItemName(addsItemNameToMessage == null ? false : addsItemNameToMessage);
                if (messagePrefix != null) {
                    bvex.setMessagePrefix(messagePrefix);
                }
                if (messagePostfix != null) {
                    bvex.setMessagePostfix(messagePostfix);
                }
                list.add(bvex);
            }
            exList = new MultipleAppException(list);
        } else {
            exList = null;
        }
        return Optional.ofNullable(exList);
    }
}

