/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util.internal;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import jp.ecuacion.lib.core.logging.DetailLogger;

public class MailUtilLogOutputStream
extends FilterOutputStream {
    private static DetailLogger detailLog = new DetailLogger(MailUtilLogOutputStream.class);
    private static final ByteArrayOutputStream bos = new ByteArrayOutputStream();

    public MailUtilLogOutputStream() {
        super(bos);
    }

    @Override
    public void flush() throws IOException {
        bos.flush();
        if (bos.size() > 0) {
            detailLog.info(bos.toString());
        }
        bos.reset();
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(new String(b));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.write(new String(b, off, len));
    }

    private void write(String string) {
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        detailLog.debug(string);
    }
}

