/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.exception.checked;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppExceptionFields;
import jp.ecuacion.lib.core.util.ObjectsUtil;

public class AppWarningException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected String messageId;
    protected String[] messageArgs;
    protected Locale locale;
    protected AppExceptionFields fields;

    public AppWarningException(@Nonnull String messageId, String ... messageArgs) {
        this(Locale.getDefault(), messageId, messageArgs);
    }

    public AppWarningException(@RequireNonnull Locale locale, @Nonnull String messageId, String ... messageArgs) {
        this.locale = ObjectsUtil.paramRequireNonNull(locale);
        this.messageId = ObjectsUtil.paramRequireNonNull(messageId);
        this.messageArgs = ObjectsUtil.paramRequireNonNull(messageArgs);
        this.fields = new AppExceptionFields(new String[0]);
    }

    @Nonnull
    public Locale getLocale() {
        return this.locale;
    }

    @Nonnull
    public String getMessageId() {
        return this.messageId;
    }

    @Nonnull
    public String[] getMessageArgs() {
        return (String[])this.messageArgs.clone();
    }

    @Nonnull
    public AppExceptionFields fields() {
        return this.fields;
    }

    @Nonnull
    public AppWarningException fields(@Nullable AppExceptionFields fields) {
        this.fields = fields != null ? fields : new AppExceptionFields(new String[0]);
        return this;
    }
}

