/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.exception.checked;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jp.ecuacion.lib.core.exception.checked.AppExceptionFields;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;

public class BizLogicAppException
extends SingleAppException {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private String messageId;
    @Nonnull
    private String[] messageArgs;
    @Nullable
    private AppExceptionFields fields;

    public BizLogicAppException(@Nonnull String messageId, String ... messageArgs) {
        this((AppExceptionFields)null, messageId, messageArgs);
    }

    public BizLogicAppException(@Nullable AppExceptionFields fields, @Nonnull String messageId, String ... messageArgs) {
        super(PropertyFileUtil.getMsg(messageId, messageArgs));
        this.messageId = ObjectsUtil.paramRequireNonNull(messageId);
        this.messageArgs = ObjectsUtil.paramRequireNonNull(messageArgs);
    }

    @Nullable
    public AppExceptionFields getErrorFields() {
        return this.fields;
    }

    @Nonnull
    public String getMessageId() {
        return this.messageId;
    }

    @Nonnull
    public String[] getMessageArgs() {
        return this.messageArgs == null ? new String[]{} : (String[])this.messageArgs.clone();
    }
}

