/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.text.NumberFormat;
import java.util.Collection;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.unchecked.RuntimeSystemException;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    @Nullable
    public String getLowerCamelFromSnakeOrNullIfInputIsNull(@Nullable String snakeCaseString) {
        if (snakeCaseString == null) {
            return null;
        }
        if (snakeCaseString.startsWith("_")) {
            throw new RuntimeSystemException("snake-case string cannot start with '_'. (argment string: '" + snakeCaseString + "')");
        }
        if (snakeCaseString.endsWith("_")) {
            throw new RuntimeSystemException("snake-case string cannot end with '_'. (argment string: '" + snakeCaseString + "')");
        }
        if (snakeCaseString.contains("__")) {
            throw new RuntimeSystemException("snake-case strings are not supposed to have '__' (double underscores). (argment string: '" + snakeCaseString + "')");
        }
        Object lowStr = StringUtils.uncapitalize((String)snakeCaseString);
        while (((String)lowStr).indexOf("_") >= 0) {
            int firstUsPos = ((String)lowStr).indexOf("_");
            lowStr = ((String)lowStr).substring(0, firstUsPos) + ((String)lowStr).substring(firstUsPos + 1, firstUsPos + 2).toUpperCase() + ((String)lowStr).substring(firstUsPos + 2);
        }
        return lowStr;
    }

    @Nullable
    public String getUpperCamelFromSnakeOrNullIfInputIsNull(@Nullable String snakeCaseString) {
        return StringUtils.capitalize((String)this.getLowerCamelFromSnakeOrNullIfInputIsNull(snakeCaseString));
    }

    @Nullable
    public String getLowerSnakeFromCamel(@Nullable String camelCaseString) {
        char[] chars;
        if (camelCaseString == null) {
            return null;
        }
        camelCaseString = StringUtils.uncapitalize((String)camelCaseString);
        for (char c : chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray()) {
            String s = String.valueOf(c);
            camelCaseString = camelCaseString.replaceAll(s, "_" + s);
        }
        return camelCaseString;
    }

    @Nonnull
    public String toCurrencyFormat(@Nonnull String number) {
        if (number == null || number.equals("")) {
            throw new NumberFormatException();
        }
        NumberFormat formatter = NumberFormat.getNumberInstance();
        return formatter.format(Integer.valueOf(number));
    }

    @Nonnull
    public String getCsv(String ... array) {
        boolean isFirstTime = true;
        StringBuffer sb = new StringBuffer();
        for (String str : array) {
            if (isFirstTime) {
                isFirstTime = false;
                sb.append(str);
                continue;
            }
            sb.append("," + str);
        }
        return sb.toString();
    }

    @Nonnull
    public String getCsv(@Nonnull Collection<String> collection) {
        return this.getCsv(collection.toArray(new String[collection.size()]));
    }

    @Nonnull
    public String getCsvWithSpace(@RequireNonnull String[] collection) {
        boolean isFirstTime = true;
        StringBuffer sb = new StringBuffer();
        for (String str : collection) {
            if (isFirstTime) {
                isFirstTime = false;
                sb.append(str);
                continue;
            }
            sb.append(", " + str);
        }
        return sb.toString();
    }

    @Nonnull
    public String getCsvWithSpace(@Nonnull Collection<String> collection) {
        return this.getCsvWithSpace(collection.toArray(new String[collection.size()]));
    }

    @Nonnull
    public String escapeHtml(@Nonnull String str) {
        StringBuffer result = new StringBuffer();
        block8: for (char c : str.toCharArray()) {
            switch (c) {
                case '&': {
                    result.append("&amp;");
                    continue block8;
                }
                case '<': {
                    result.append("&lt;");
                    continue block8;
                }
                case '>': {
                    result.append("&gt;");
                    continue block8;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    result.append("&#39;");
                    continue block8;
                }
                case ' ': {
                    result.append("&nbsp;");
                    continue block8;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }
}

