/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.exception.unchecked;

import jakarta.annotation.Nonnull;
import java.util.Locale;
import jp.ecuacion.lib.core.util.ObjectsUtil;

public class RuntimeExceptionWithMessageId
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private String messageId;
    @Nonnull
    private String[] messageArgs;
    @Nonnull
    private Locale locale;

    public RuntimeExceptionWithMessageId(@Nonnull String messageId) {
        this(messageId, new String[0]);
    }

    public RuntimeExceptionWithMessageId(@Nonnull String messageId, String ... messageArgs) {
        this(Locale.getDefault(), messageId, messageArgs);
    }

    public RuntimeExceptionWithMessageId(@Nonnull Locale locale, @Nonnull String messageId) {
        this(locale, messageId, new String[0]);
    }

    public RuntimeExceptionWithMessageId(@Nonnull Locale locale, @Nonnull String messageId, String ... messageArgs) {
        this.locale = ObjectsUtil.paramRequireNonNull(locale);
        this.messageId = ObjectsUtil.paramRequireNonNull(messageId);
        this.messageArgs = ObjectsUtil.paramRequireNonNull(messageArgs);
    }

    @Nonnull
    public String getMessageId() {
        return this.messageId;
    }

    @Nonnull
    public Locale getLocale() {
        return this.locale;
    }

    @Nonnull
    public String[] getMessageArgs() {
        return this.messageArgs == null ? new String[]{} : (String[])this.messageArgs.clone();
    }
}

