/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.exception.checked;

import jakarta.annotation.Nonnull;
import jakarta.validation.ConstraintViolation;
import java.util.HashMap;
import java.util.Map;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.util.ObjectsUtil;

public class BeanValidationAppException
extends SingleAppException {
    private static final long serialVersionUID = 1L;
    private String annotation;
    private Map<String, Object> annotationAttributes;
    private String message;
    private String messageTemplate;
    private String rootClassName;
    private String leafClassName;
    private String propertyPath;
    private String invalidValue;
    private Object instance;

    public <T> BeanValidationAppException(@Nonnull ConstraintViolation<T> violation) {
        ObjectsUtil.paramRequireNonNull(violation);
        this.annotation = violation.getConstraintDescriptor().getAnnotation().annotationType().getCanonicalName();
        this.annotationAttributes = violation.getConstraintDescriptor().getAttributes();
        this.message = violation.getMessage();
        this.messageTemplate = violation.getMessageTemplate();
        if (this.messageTemplate.startsWith("{")) {
            this.messageTemplate = this.messageTemplate.replace("{", "").replace("}", "");
        }
        this.rootClassName = violation.getRootBeanClass().getName();
        this.leafClassName = violation.getLeafBean().getClass().getName();
        this.propertyPath = violation.getPropertyPath().toString();
        this.invalidValue = violation.getInvalidValue() == null ? "null" : violation.getInvalidValue().toString();
        this.instance = violation.getLeafBean();
    }

    public Map<String, Object> getAnnotationAttributes() {
        return new HashMap<String, Object>(this.annotationAttributes);
    }

    @Nonnull
    public String getAnnotation() {
        return this.annotation;
    }

    @Override
    @Nonnull
    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    @Nonnull
    public String getRootClassName() {
        return this.rootClassName;
    }

    @Nonnull
    public String getLeafClassName() {
        return this.leafClassName;
    }

    @Nonnull
    public String getPropertyPath() {
        return this.propertyPath;
    }

    @Nonnull
    public String getInvalidValue() {
        return this.invalidValue;
    }

    @Nonnull
    public Object getInstance() {
        return this.instance;
    }

    @Nonnull
    public String getMessageId() {
        return this.annotation;
    }

    @Override
    @Nonnull
    public String toString() {
        return "message:" + this.message + "\nannotation:" + this.annotation + "\nrootClassName:" + this.rootClassName + "\nleafClassName:" + this.leafClassName + "\npropertyPath:" + this.propertyPath + "\ninvalidValue:" + this.invalidValue;
    }
}

