/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.exception.checked;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import jp.ecuacion.lib.core.exception.checked.AppExceptionFields;
import jp.ecuacion.lib.core.util.ObjectsUtil;

public class AppWarningException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String messageId;
    private String[] messageArgs;
    private Locale locale;
    private AppExceptionFields fields;
    private String buttonId;

    public AppWarningException(@Nonnull String messageId, String ... messageArgs) {
        this(Locale.getDefault(), messageId, messageArgs);
    }

    public AppWarningException(@Nonnull AppExceptionFields warnFields, @Nonnull String messageId, String ... messageArgs) {
        this(Locale.getDefault(), warnFields, messageId, messageArgs);
    }

    public AppWarningException(@Nonnull Locale locale, @Nonnull String messageId, String ... messageArgs) {
        this(locale, new AppExceptionFields(new String[0]), messageId, messageArgs);
    }

    public AppWarningException(@Nonnull Locale locale, @Nonnull AppExceptionFields warnFields, @Nonnull String messageId, String ... messageArgs) {
        this(locale, null, warnFields, messageId, messageArgs);
    }

    public AppWarningException(@Nonnull Locale locale, @Nullable String buttonId, @Nullable AppExceptionFields warnFields, @Nonnull String messageId, String ... messageArgs) {
        this.locale = ObjectsUtil.paramRequireNonNull(locale);
        this.buttonId = buttonId;
        this.fields = ObjectsUtil.paramRequireNonNull(warnFields);
        this.messageId = ObjectsUtil.paramRequireNonNull(messageId);
        this.messageArgs = ObjectsUtil.paramRequireNonNull(messageArgs);
    }

    @Nonnull
    public Locale getLocale() {
        return this.locale;
    }

    @Nonnull
    public AppExceptionFields getWarnFields() {
        return this.fields;
    }

    @Nonnull
    public String getMessageId() {
        return this.messageId;
    }

    @Nonnull
    public String[] getMessageArgs() {
        return (String[])this.messageArgs.clone();
    }

    @Nullable
    public String getButtonId() {
        return this.buttonId;
    }
}

