/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.exception.checked;

import jakarta.annotation.Nonnull;
import java.util.Locale;
import jp.ecuacion.lib.core.exception.checked.AppExceptionFields;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.util.ObjectsUtil;

public class BizLogicAppException
extends SingleAppException {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private String messageId;
    @Nonnull
    private String[] messageArgs;
    @Nonnull
    private Locale locale;
    @Nonnull
    private AppExceptionFields fields;

    public BizLogicAppException(@Nonnull String messageId) {
        this(messageId, new String[0]);
    }

    public BizLogicAppException(@Nonnull String messageId, String ... messageArgs) {
        this(Locale.getDefault(), messageId, messageArgs);
    }

    public BizLogicAppException(@Nonnull AppExceptionFields fields, @Nonnull String messageId) {
        this(fields, messageId, new String[0]);
    }

    public BizLogicAppException(@Nonnull AppExceptionFields fields, @Nonnull String messageId, String ... messageArgs) {
        this(Locale.getDefault(), fields, messageId, messageArgs);
    }

    public BizLogicAppException(@Nonnull Locale locale, @Nonnull String messageId) {
        this(locale, messageId, new String[0]);
    }

    public BizLogicAppException(@Nonnull Locale locale, @Nonnull String messageId, String ... messageArgs) {
        this(locale, new AppExceptionFields(new String[0]), messageId, messageArgs);
    }

    public BizLogicAppException(@Nonnull Locale locale, @Nonnull AppExceptionFields fields, @Nonnull String messageId) {
        this(locale, fields, messageId, new String[0]);
    }

    public BizLogicAppException(Locale locale, AppExceptionFields fields, String messageId, String ... messageArgs) {
        this.locale = ObjectsUtil.paramRequireNonNull(locale);
        this.fields = ObjectsUtil.paramRequireNonNull(fields);
        this.messageId = ObjectsUtil.paramRequireNonNull(messageId);
        this.messageArgs = ObjectsUtil.paramRequireNonNull(messageArgs);
    }

    @Nonnull
    public Locale getLocale() {
        return this.locale;
    }

    @Nonnull
    public AppExceptionFields getErrorFields() {
        return this.fields;
    }

    @Nonnull
    public String getMessageId() {
        return this.messageId;
    }

    @Nonnull
    public String[] getMessageArgs() {
        return this.messageArgs == null ? new String[]{} : (String[])this.messageArgs.clone();
    }
}

