/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.LogUtil;
import jp.ecuacion.lib.core.util.internal.PropertyFileUtilPropFileKindEnum;

public class PropertyFileUtilKeyGetterByFileKind {
    private DetailLogger detailLogger;
    private PropertyFileUtilPropFileKindEnum kind;
    private String filePrefix;
    private static final Locale LOCALE_FOR_LOCALE_UNNEEDED_PROPERTIES = Locale.JAPANESE;
    static String bundleForPropertyFileUtil = "application_for_property-file-util_base";
    private static final String[] ECUACION_LIB_MODULES = new String[]{"core", "jpa"};
    private static final String[] ECUACION_LIB_JAKARTAEE_MODULES = new String[]{"batch", "core", "jpa_eclipselink", "web", "web_jaxrs_client", "web_jaxrs_jersey", "web_jaxrs_client_jersey"};
    private static final String[] ECUACION_SPLIB_MODULES = new String[]{"web"};
    private static final String[] ECUACION_UTIL_TOOLS_MODULES = new String[]{"jpa", "poi"};
    private static final String[] SYSTEM_MODULES = new String[]{"", "base", "core", "core_web", "core_batch"};
    private static final String[] SYSTEM_ENVS = new String[]{"", "profile"};
    private static final String[] OTHERS = new String[]{"ValidationMessages", "test"};

    public PropertyFileUtilKeyGetterByFileKind(PropertyFileUtilPropFileKindEnum fileKindEnum) {
        Objects.requireNonNull(fileKindEnum);
        this.kind = fileKindEnum;
        this.filePrefix = fileKindEnum.getFilePrefix();
        this.onConstruct();
    }

    PropertyFileUtilKeyGetterByFileKind(String filePrefix) {
        Objects.requireNonNull(filePrefix);
        this.kind = PropertyFileUtilPropFileKindEnum.MSG;
        this.filePrefix = filePrefix;
        this.onConstruct();
    }

    private void onConstruct() {
        String strDefaultLocale = null;
        ResourceBundle bundle = null;
        this.detailLogger = new DetailLogger(this);
        try {
            bundle = ResourceBundle.getBundle(bundleForPropertyFileUtil);
            strDefaultLocale = bundle.getString("DEFAULT_LOCALE");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (strDefaultLocale != null && !strDefaultLocale.equals("")) {
            String[] args = strDefaultLocale.split("_");
            if (args.length == 1) {
                Locale.setDefault(Locale.of(strDefaultLocale));
            } else {
                Locale.setDefault(Locale.of(args[0], args[1]));
            }
        } else {
            this.detailLogger.trace("DEFAULT_LOCALE not defined. System.getDefault() is used.");
        }
    }

    private List<String> getFileNamePostfixes() {
        ArrayList<String> rtnList = new ArrayList<String>();
        rtnList.addAll(Arrays.asList(ECUACION_LIB_MODULES).stream().map(str -> "lib_" + str).collect(Collectors.toList()));
        rtnList.addAll(Arrays.asList(ECUACION_LIB_JAKARTAEE_MODULES).stream().map(str -> "jeelib_" + str).collect(Collectors.toList()));
        rtnList.addAll(Arrays.asList(ECUACION_SPLIB_MODULES).stream().map(str -> "splib_" + str).collect(Collectors.toList()));
        rtnList.addAll(Arrays.asList(ECUACION_UTIL_TOOLS_MODULES).stream().map(str -> "util_" + str).toList());
        rtnList.addAll(Arrays.asList(OTHERS));
        for (String systemModuleName : SYSTEM_MODULES) {
            for (String envName : SYSTEM_ENVS) {
                boolean needsUs = !systemModuleName.equals("") && !envName.equals("");
                rtnList.add(systemModuleName + (needsUs ? "_" : "") + envName);
            }
        }
        return rtnList;
    }

    private String readPropFile(Locale locale, String key) {
        String value = null;
        List<String> postfixes = this.getFileNamePostfixes();
        for (int i = 0; i < postfixes.size(); ++i) {
            String postfix = postfixes.get(i);
            String filename = this.filePrefix + (postfix.equals("") ? "" : "_") + postfix;
            String tmpValue = this.readOnePropFile(filename, locale, key, value != null);
            if (tmpValue == null) continue;
            value = tmpValue;
        }
        if (value == null && this.kind == PropertyFileUtilPropFileKindEnum.MSG) {
            value = this.readOnePropFile("ValidationMessages", locale, key, false);
        }
        return value;
    }

    private String readOnePropFile(String filename, Locale locale, String key, boolean valueObtained) {
        ResourceBundle bundle = null;
        Objects.requireNonNull(filename);
        Objects.requireNonNull(locale);
        try {
            bundle = ResourceBundle.getBundle(filename, locale);
        }
        catch (MissingResourceException e) {
            this.detailLogger.trace("(not a problem) jp.ecuacion.lib.core.util.internal.PropertyFileUtil: property file not exist\uff08" + filename + "\uff09");
            return null;
        }
        if (!bundle.containsKey(key)) {
            return null;
        }
        String val = bundle.getString(key);
        if (val != null && valueObtained) {
            throw new RuntimeException("Duplicate key in Property File.[file=" + bundle.getBaseBundleName() + ", key=" + key + "]");
        }
        return val;
    }

    public boolean hasProp(String key) {
        return this.hasProp(LOCALE_FOR_LOCALE_UNNEEDED_PROPERTIES, key);
    }

    public boolean hasProp(Locale locale, String key) {
        Objects.requireNonNull(locale);
        Objects.requireNonNull(key);
        String val = this.readPropFile(locale, key);
        return val != null;
    }

    public String getProp(String key) {
        return this.getProp(LOCALE_FOR_LOCALE_UNNEEDED_PROPERTIES, key);
    }

    public String getProp(Locale locale, String key) {
        Objects.requireNonNull(locale);
        Objects.requireNonNull(key);
        String str = this.readPropFile(locale, key);
        String defaultStr = this.readPropFile(locale, key + ".default");
        if (str == null && defaultStr == null) {
            try {
                throw new RuntimeException("No key in .properties. key: " + key);
            }
            catch (Exception e) {
                new LogUtil(this).logError((Throwable)e, (String)null);
                throw e;
            }
        }
        return str != null ? str : defaultStr;
    }

    public boolean isOverrided(String key) {
        return System.getProperties().keySet().contains(key);
    }
}

