/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.exception.checked;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.util.ObjectsUtil;

public class MultipleAppException
extends AppException {
    private static final long serialVersionUID = 1L;
    private List<SingleAppException> exceptionList;

    public MultipleAppException(@Nonnull List<? extends SingleAppException> list) {
        ObjectsUtil.paramRequireNonNull(list);
        ObjectsUtil.paramSizeNonZero(list);
        ArrayList<SingleAppException> internalList = new ArrayList<SingleAppException>();
        for (SingleAppException singleAppException : list) {
            internalList.add(singleAppException);
        }
        this.exceptionList = internalList;
    }

    public MultipleAppException(@Nonnull MultipleAppException ex) {
        ArrayList<SingleAppException> internalList = new ArrayList<SingleAppException>();
        internalList.addAll(ex.getList());
        this.exceptionList = internalList;
    }

    @Nonnull
    public List<SingleAppException> getList() {
        return new ArrayList<SingleAppException>(this.exceptionList);
    }
}

