/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.beanvalidation.bean.BeanValidationErrorInfoBean;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BeanValidationAppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.exception.unchecked.RuntimeAppException;
import jp.ecuacion.lib.core.exception.unchecked.RuntimeExceptionWithMessageId;
import jp.ecuacion.lib.core.exception.unchecked.RuntimeSystemException;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import org.apache.commons.lang3.StringUtils;

public class ExceptionUtil {
    private static final String RT = "\n";

    @Nonnull
    public List<String> getExceptionMessage(@RequireNonnull Throwable throwable, boolean needsDetails) {
        return this.getExceptionMessage(throwable, Locale.getDefault(), needsDetails);
    }

    @Nonnull
    public List<String> getExceptionMessage(@RequireNonnull Throwable throwable, @Nullable Locale locale, boolean needsDetails) {
        ObjectsUtil.paramRequireNonNull(throwable);
        locale = locale == null ? Locale.getDefault() : locale;
        ObjectsUtil.paramRequireNonNull(needsDetails);
        ArrayList<Throwable> exList = new ArrayList<Throwable>();
        ArrayList<String> rtnList = new ArrayList<String>();
        if (throwable instanceof ConstraintViolationException) {
            ConstraintViolationException cve = (ConstraintViolationException)throwable;
            for (ConstraintViolation cv : cve.getConstraintViolations()) {
                exList.add(new BeanValidationAppException(cv));
            }
        } else {
            exList.add(throwable);
        }
        for (Throwable th : exList) {
            Exception ex;
            if (th instanceof MultipleAppException) continue;
            if (th instanceof BizLogicAppException && th.getCause() == null) {
                ex = (BizLogicAppException)th;
                rtnList.add(PropertyFileUtil.getMsg(locale, ((BizLogicAppException)ex).getMessageId(), ((BizLogicAppException)ex).getMessageArgs()));
                continue;
            }
            if (th instanceof BeanValidationAppException) {
                ex = (BeanValidationAppException)th;
                String message = null;
                try {
                    BeanValidationErrorInfoBean bean = ((BeanValidationAppException)ex).getBeanValidationErrorInfoBean();
                    message = bean.getMessage();
                    if (message.contains("{0}")) {
                        String className = bean.getRootClassName().substring(bean.getRootClassName().lastIndexOf(".") + 1);
                        Object itemName = StringUtils.uncapitalize((String)className) + "." + bean.getPropertyPath();
                        if (((String)itemName).split("\\.").length > 2) {
                            while (((String)(itemName = ((String)itemName).substring(((String)itemName).indexOf(".") + 1))).split("\\.").length != 2) {
                            }
                        }
                        if (PropertyFileUtil.hasFieldName((String)itemName)) {
                            itemName = PropertyFileUtil.getFieldName(locale, (String)itemName);
                        }
                        message = MessageFormat.format(message, itemName);
                    }
                }
                catch (MissingResourceException mre) {
                    message = ex.getMessage();
                }
                rtnList.add((String)(needsDetails ? message + RT + ((BeanValidationAppException)ex).toString() : message));
                continue;
            }
            if (th instanceof RuntimeExceptionWithMessageId) {
                ex = (RuntimeExceptionWithMessageId)th;
                rtnList.add(PropertyFileUtil.getMsg(locale, ((RuntimeExceptionWithMessageId)ex).getMessageId(), ((RuntimeExceptionWithMessageId)ex).getMessageArgs()));
                continue;
            }
            rtnList.add(th.getMessage());
        }
        return rtnList;
    }

    @Nonnull
    private List<Throwable> serializeExceptions(@RequireNonnull Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        this.recursivelySerializeException(throwable, list);
        return ObjectsUtil.returnRequireNonNull(list);
    }

    private void recursivelySerializeException(@RequireNonnull Throwable throwable, List<Throwable> arr) {
        arr.add(throwable);
        if (throwable instanceof MultipleAppException) {
            for (AppException appException : ((MultipleAppException)throwable).getList()) {
                this.recursivelySerializeException(appException, arr);
            }
        } else if (throwable.getCause() != null) {
            this.recursivelySerializeException(throwable.getCause(), arr);
        }
    }

    @Nonnull
    public List<Throwable> getExceptionListWithMessages(@RequireNonnull Throwable throwable) {
        ObjectsUtil.paramRequireNonNull(throwable);
        ArrayList<Throwable> rtnList = new ArrayList<Throwable>();
        for (Throwable th : this.serializeExceptions(throwable)) {
            if (th instanceof RuntimeAppException) {
                rtnList.add(((RuntimeAppException)th).getCause());
                continue;
            }
            if (!(th instanceof SingleAppException) && !(th instanceof RuntimeExceptionWithMessageId) && !(th instanceof RuntimeSystemException) && (th.getMessage() == null || th.getMessage().equals(""))) continue;
            rtnList.add(th);
        }
        return rtnList;
    }

    @Nonnull
    public List<SingleAppException> getSingleAppExceptionList(@RequireNonnull AppException appException) {
        ObjectsUtil.paramRequireNonNull(appException);
        ArrayList<SingleAppException> rtnList = new ArrayList<SingleAppException>();
        this.serializeExceptions(appException).forEach(ex -> {
            if (ex instanceof SingleAppException) {
                rtnList.add((SingleAppException)ex);
            }
        });
        if (rtnList.isEmpty()) {
            throw new RuntimeException(appException);
        }
        return rtnList;
    }

    @Nonnull
    public List<String> getAppExceptionMessageList(@RequireNonnull AppException appException, @Nullable Locale locale) {
        ArrayList<String> rtnList = new ArrayList<String>();
        this.getSingleAppExceptionList(appException).stream().map(ex -> this.getExceptionMessage((Throwable)ex, locale, false)).forEach(list -> rtnList.addAll((Collection<String>)list));
        return rtnList;
    }

    @Nonnull
    public String getErrLogString(@RequireNonnull Throwable throwable, @Nullable String additionalMessage, @Nullable Locale locale) {
        ObjectsUtil.paramRequireNonNull(throwable);
        locale = locale == null ? Locale.getDefault() : locale;
        StringBuilder sb = new StringBuilder();
        sb.append("=============== system error occured ===============\n");
        if (additionalMessage != null) {
            sb.append(additionalMessage + RT);
            sb.append(RT);
        }
        sb.append(RT);
        this.getErrInfoRecursively(sb, throwable, locale);
        return sb.toString();
    }

    private void getErrInfoRecursively(StringBuilder sb, Throwable th, Locale locale) {
        locale = locale == null ? Locale.getDefault() : locale;
        sb.append(th.getClass().getName() + RT);
        String errMsg = this.getExceptionMessage(th, locale, true).toString();
        if (errMsg != null) {
            sb.append(errMsg + RT);
        }
        this.getStackTraceString(sb, th);
        if (th.getCause() != null) {
            this.getErrInfoRecursively(sb, th.getCause(), locale);
        }
    }

    private void getStackTraceString(StringBuilder sb, Throwable th) {
        for (StackTraceElement ste : th.getStackTrace()) {
            sb.append("\tat " + ste.getClassName() + "." + ste.getMethodName() + "(" + ste.getFileName() + ":" + ste.getLineNumber() + ")\n");
        }
    }
}

