/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jp.ecuacion.lib.core.exception.checked.BeanValidationAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;

public class BeanValidationUtil {
    private ConcurrentMap<Locale, Validator> validatorCache = new ConcurrentHashMap<Locale, Validator>();

    public <T> void validateThenThrow(@Nonnull T object) throws MultipleAppException {
        MultipleAppException exList = this.validateThenReturn(object);
        if (exList != null && exList.getList().size() > 0) {
            throw exList;
        }
    }

    public <T> void validateThenThrow(@Nonnull T object, @Nullable Locale locale) throws MultipleAppException {
        MultipleAppException exList = this.validateThenReturn(object, locale);
        if (exList != null && exList.getList().size() > 0) {
            throw exList;
        }
    }

    @Nullable
    public <T> MultipleAppException validateThenReturn(@Nonnull T object) {
        return this.validateThenReturn(object, Locale.getDefault());
    }

    @Nullable
    public <T> MultipleAppException validateThenReturn(@Nonnull T object, @Nullable Locale locale) {
        Set<ConstraintViolation<T>> set = this.validate(object, locale);
        MultipleAppException exList = null;
        if (set != null && set.size() > 0) {
            ArrayList<BeanValidationAppException> list = new ArrayList<BeanValidationAppException>();
            for (ConstraintViolation<T> v : set) {
                list.add(new BeanValidationAppException(v));
            }
            exList = new MultipleAppException(list);
        } else {
            exList = null;
        }
        return exList;
    }

    @Nonnull
    public <T> Set<ConstraintViolation<T>> validate(@Nonnull T object, @Nullable Locale locale) {
        ObjectsUtil.paramRequireNonNull(object);
        locale = locale == null ? Locale.getDefault() : locale;
        Validator validator = this.validatorCache.computeIfAbsent(locale, keyLocale -> Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new LocaleSpecifiedMessageInterpolator((Locale)keyLocale)).buildValidatorFactory().getValidator());
        return validator.validate(object, new Class[0]);
    }

    private static class LocaleSpecifiedMessageInterpolator
    implements MessageInterpolator {
        private Locale locale;
        private MessageInterpolator mi;

        public LocaleSpecifiedMessageInterpolator(Locale locale) {
            this.locale = locale;
            this.mi = new ResourceBundleMessageInterpolator();
        }

        public String interpolate(String m, MessageInterpolator.Context c) {
            return this.mi.interpolate(m, c, this.locale);
        }

        public String interpolate(String m, MessageInterpolator.Context c, Locale l) {
            return this.mi.interpolate(m, c, this.locale);
        }
    }
}

