/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.text.MessageFormat;
import java.util.Locale;
import jp.ecuacion.lib.core.exception.unchecked.RuntimeSystemException;
import jp.ecuacion.lib.core.util.internal.PropertyFileUtilKeyGetterByFileKind;
import jp.ecuacion.lib.core.util.internal.PropertyFileUtilPropFileKindEnum;

public class PropertyFileUtil {
    private static PropertyFileUtilKeyGetterByFileKind appPropStore = new PropertyFileUtilKeyGetterByFileKind(PropertyFileUtilPropFileKindEnum.APP);
    private static PropertyFileUtilKeyGetterByFileKind svrMsgStore = new PropertyFileUtilKeyGetterByFileKind(PropertyFileUtilPropFileKindEnum.MSG);
    private static PropertyFileUtilKeyGetterByFileKind fieldNamesStore = new PropertyFileUtilKeyGetterByFileKind(PropertyFileUtilPropFileKindEnum.FIELD_NAME);
    private static PropertyFileUtilKeyGetterByFileKind enumNamesStore = new PropertyFileUtilKeyGetterByFileKind(PropertyFileUtilPropFileKindEnum.ENUM_NAME);

    private PropertyFileUtil() {
    }

    @Nonnull
    public static String getApp(@Nonnull String key) {
        return appPropStore.getProp(key);
    }

    public static boolean hasApp(@Nonnull String key) {
        return appPropStore.hasProp(key);
    }

    @Nonnull
    public static String getMsg(@Nonnull String key) {
        return PropertyFileUtil.getMsg(Locale.getDefault(), key);
    }

    @Nonnull
    public static String getMsg(@Nullable Locale locale, @Nonnull String key) {
        return PropertyFileUtil.getMsg(locale, key, (String[])null);
    }

    @Nonnull
    public static String getMsg(@Nonnull String key, String ... args) {
        return PropertyFileUtil.getMsg(Locale.getDefault(), key, args);
    }

    @Nonnull
    public static String getMsg(@Nullable Locale locale, @Nonnull String key, String ... args) {
        if (key == null || key.equals("")) {
            throw new RuntimeSystemException("Message ID is null or blank.");
        }
        String msgStr = svrMsgStore.getProp(locale, key);
        if (args == null) {
            args = new String[]{};
        }
        return args.length == 0 ? msgStr : MessageFormat.format(msgStr, args);
    }

    public static boolean hasMsg(@Nonnull String msgId) {
        return svrMsgStore.hasProp(Locale.getDefault(), msgId);
    }

    @Nonnull
    public static String getFieldName(@Nonnull String key) {
        return fieldNamesStore.getProp(Locale.getDefault(), key);
    }

    @Nonnull
    public static String getFieldName(@Nullable Locale locale, @Nonnull String key) {
        return fieldNamesStore.getProp(locale, key);
    }

    public static boolean hasFieldName(@Nonnull String key) {
        return fieldNamesStore.hasProp(Locale.getDefault(), key);
    }

    @Nonnull
    public static String getEnumName(@Nonnull String key) {
        return enumNamesStore.getProp(Locale.getDefault(), key);
    }

    @Nonnull
    public static String getEnumName(@Nullable Locale locale, @Nonnull String key) {
        return enumNamesStore.getProp(locale, key);
    }

    public static boolean hasEnumName(@Nonnull String key) {
        return enumNamesStore.hasProp(Locale.getDefault(), key);
    }
}

