/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.logging.internal;

import jp.ecuacion.lib.core.exception.unchecked.RuntimeSystemException;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogger {
    private Logger internalLogger;

    public AbstractLogger(String loggerName) {
        this.internalLogger = LoggerFactory.getLogger((String)loggerName);
    }

    public AbstractLogger(Class<?> cls) {
        this.internalLogger = LoggerFactory.getLogger((String)cls.getName());
    }

    protected void log(String message, LogLevel logLevel) {
        ObjectsUtil.paramRequireNonNull(message);
        ObjectsUtil.paramRequireNonNull(logLevel);
        if (logLevel == LogLevel.error) {
            this.internalLogger.error(message);
        } else if (logLevel == LogLevel.warn) {
            this.internalLogger.warn(message);
        } else if (logLevel == LogLevel.info) {
            this.internalLogger.info(message);
        } else if (logLevel == LogLevel.debug) {
            this.internalLogger.debug(message);
        } else if (logLevel == LogLevel.trace) {
            this.internalLogger.trace(message);
        } else {
            throw new RuntimeSystemException("nonexistent Loglevel : " + String.valueOf((Object)logLevel));
        }
    }

    protected void logThrowable(Throwable th) {
        ObjectsUtil.paramRequireNonNull(th);
        this.internalLogger.error("A system error has occured: ", th);
    }

    public static enum LogLevel {
        error,
        warn,
        info,
        debug,
        trace;

    }
}

